<style>
form{
    display:inline-block;
    width:100%;
}
    .w-18{
        width:18%;
        float:left;
        padding-left:10px;
    }
    
    .w-10{
        width:10%;
        float:left;
        padding-left:10px;
    }
    
    .search-btn{
        padding:10px 7px;
        border-radius:5px;
        outline:none;
        box-shadow:4px 4px 8px silver;
    }
</style>
<div class="container-fluid bg-white mt-3 mb-3 pt-3 pb-3">
    <div class="row">
        <div class="col-sm-12">
            
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo base_url();?>Welcome">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo base_url();?>Fee/all_students">Fee</a></li>
                <li class="breadcrumb-item"><a href="#"></a>Invoices</li>
            </ul>
            
            <form method="post" action="#">
                <?php 
                $start_date=$this->session->userdata("search_filter_start_date");
                $end_date=$this->session->userdata("search_filter_end_date");
                $class=$this->session->userdata("search_filter_class");
                $section=$this->session->userdata("search_filter_section");
                $student_name=$this->session->userdata("search_filter_student_name");

                ?>
                <div class="form-group w-18">
                    <label>Start Date <span class="text-danger">*</span></label>
                    <input type="date" name="start_date" class="form-control" value="<?php if($start_date){ echo $start_date; }else{ echo date("Y-m-01"); } ?>" required>
                </div>
                
                <div class="form-group w-18">
                    <label>End Date <span class="text-danger">*</span></label>
                    <input type="date" name="end_date" class="form-control" value="<?php if($end_date){ echo $end_date; }else{ echo date("Y-m-d"); } ?>" required>
                </div>
                <div class="form-group w-18">
                    <label>Class</label>
                    <select class="form-control class-list" name="class">
                        <option value="">--- Select Class ---</option>
                        <?php 
                        $courses_table="courses";
                        $get_class_list=$this->NewFeeModel->get_class_list($courses_table);
                        if($get_class_list){
                            foreach($get_class_list as $classes){
                        ?>
                        <option value="<?php echo $classes['course']; ?>"  <?php if($classes['course'] == $class){ echo "selected"; } ?> ><?php echo $classes['course']; ?></option>
                        <?php
                            }
                        }
                        ?>
                        
                    </select>
                    <!--<input type="date" name="start_date" class="form-control" value="">-->
                </div>
                
                <div class="form-group w-18">
                    <label>Section</label>
                    <!--<input type="date" name="section" class="form-control" value="">-->
                    <select class="form-control section-list" name="section">
                        <option value="">--- Select Section ---</option>
                    </select>
                </div>
                
                <div class="form-group w-18">
                    <label>Student Name</label>
                    <input type="text" name="student_name" class="form-control" value="<?php $student_name; ?>">
                </div>
                
                <div class="form-group w-10">
                    <label>&nbsp;&nbsp;</label><br>
                    <button class="search-btn" type="submit" name="invoice-filter">Search</button>
                </div>
            </form>
            <div class="table-responsive">
                <table class="table table-bordered " id="mytable">
                    
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Fee No.</th>
                            <th>S. Id.</th>
                            
                            <th>Name</th>
                            <th>Father's Name</th>
                            <th>Est Amount</th>
                            <th>Received Amount</th>
                            <th>Discount</th>
                            <!--<th>Fee Months</th>-->
                            <!--<th>Fee Type</th>-->
                            <th>Bill Book No.</th>
                            <th>Course</th>
                            <th>Date</th>
                            <th>Invoices</th>
                            <th>Edit</th>
                            
                            <?php 
                            if($this->session->userdata('all_permission') ==1){
                                ?>
                                <th class="text-danger">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash-fill" viewBox="0 0 16 16">
                                    <path d="M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 1 0z"/>
                                </svg>
                                </th>
                                <?php
                            }
                            ?>
                            
                        </tr>
                    </thead>
                    
                    <tbody>
                        <?php 
                        $count=0;
                        if($invoices){
                            foreach($invoices as $inv){
                                $count++;
                        ?>
                        <tr>
                            <td><?php echo $count; ?></td>
                            <td><?php echo $inv['fee_no'];  ?></td>
                            <td><?php echo $inv['sid'];  ?></td>
                            <td><?php echo $inv['student_name'];  ?></td>
                            <td><?php echo $inv['father_name'];  ?></td>
                            <td><?php echo $inv['estimate_amount'];?></td>
                            <td><?php echo $inv['received_amount'];?></td>
                            <td><?php echo $inv['discount'];?></td>
                            <td><?php echo $inv['bill_book_no'];?></td>
                            <td><?php echo $inv['student_class']." ".$inv['section']; ?> <?php if($inv['subject_stream']){ ?> (<?php echo $inv['subject_stream'];?>)<?php } ?></td>
                            <td><?php echo date("d-m-Y",strtotime($inv['fee_date']));?></td>
                            <td>
                                        <a href="<?php echo base_url();?>Fee/invoice/<?php echo $inv['fee_no'];?>" class="btn btn-sm btn-info" style="color:#fff;" target="_blank">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-printer-fill" viewBox="0 0 16 16">
                                                <path d="M5 1a2 2 0 0 0-2 2v1h10V3a2 2 0 0 0-2-2H5zm6 8H5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1z"/>
                                                <path d="M0 7a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2h-1v-2a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v2H2a2 2 0 0 1-2-2V7zm2.5 1a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1z"/>
                                            </svg>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?php echo base_url();?>Fee/edit_fee_data/<?php echo $inv['fee_no'];?>" class="btn btn-sm btn-warning">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                                                <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
                                            </svg>
                                        </a>
                                    </td>
                            <?php 
                            if($this->session->userdata('all_permission') ==1){
                                ?>
                                    <td><button class="text-danger btn btn-sm" id="item_to_trash" item_id="<?php echo $inv['fee_no'];?>"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash-fill" viewBox="0 0 16 16"><path d="M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 1 0z"/></svg></button></td>
                                
                            <?php
                            }
                            ?>
                        </tr>
                        <?php
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function(){
        // alert("Hi");
        $(document).on("change",".class-list",function(){
            var course=$(this).val();
            get_course_section(course);
        });
        <?php 
        if($class !=""){
        ?>
        var course="<?php echo $class; ?>";
        get_course_section(course);
        <?php
        }
        ?>
        function get_course_section(course){
            $.ajax({
                url: '<?php echo base_url(); ?>Fee/get_course_sections',
                type: 'POST',
                data:{course:course},
                success: function(data){
                    // alert(data);
                    $(".section-list").html(data);
                }
            });
        }
    });
</script>