<?php
$month=$this->uri->segment(3); 
$dateObj   = DateTime::createFromFormat('!m', $month);
$monthName = $dateObj->format('F'); // March
$acedemic_session=$this->session->userdata('acedemic_session');
$table='accounts_ledger';
$all_records=$this->AccountsModel->get_month_data($month,$acedemic_session,$table);
?>
<div class="container-fluid bg-white">
    <div class="row">
        <div class="col-sm-12 pt-3 pb-3">
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Welcome">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Accounts">Accounts</a></li>
                <li class="breadcrumb-item"><?php echo $monthName; ?></li>
            </ul>
            
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Particulars</th>
                            <th>Date</th>
                            <th>Description</th>
                            <th>Credit</th>
                            <th>Debit</th>
                            <th>Balance</th>
                            <th>Attachment</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_debit=0;
                        $total_credit=0;
                        if($all_records){
                            foreach($all_records as $ledger){
                                $credit=0;
                                $debit=0;
                                if($ledger['type'] =="debit"){
                                    $debit=$debit + $ledger['amount'];
                                    $total_debit=$total_debit + $debit;
                                }else if($ledger['type'] =="credit"){
                                    $credit=$credit + $ledger['amount'];
                                    $total_credit = $total_credit + $credit;
                                }
                        ?>
                        
                        <tr>
                            <td><?php echo $ledger['particulars']; ?></td>
                            <td><?php echo date('d-m-Y',strtotime($ledger['date'])); ?></td>
                            <td><?php echo $ledger['description']; ?></td>
                            <td><?php if($credit == 0){ echo "--"; }else{ echo $credit; }  ?></td>
                            <td><?php if($debit == 0){ echo "--"; }else{ echo $debit; }  ?></td>
                            <td></td>
                            <td>
                                <?php 
                                if($ledger['attachment'] !=""){
                                ?>
                                <a href="<?php echo base_url()."assets/accounts/".$ledger['attachment']; ?>" target="_blank">View</a>
                                <?php 
                                }
                                ?>
                            </td>
                            <td>
                                <form method="post" action="<?php echo base_url(); ?>Accounts/add_new_record"><button class="btn btn-sm btn-warning" name="edit" value="<?php echo $ledger['id']; ?>">Edit</button></form>
                            </td>
                        </tr>
                        <?php
                            }
                        }
                        ?>
                        <tr>
                            <th>Total</th>
                            <th></th>
                            <th></th>
                            <th><?php echo $total_credit; ?></th>
                            <th><?php echo $total_debit; ?></th>
                            <th><?php echo $total_credit - $total_debit; ?></th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>