<?php
class NewExamModel extends CI_MODEL{
    
    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }

    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id','DESC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_data_asc($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_exist($acedemic_session,$exam_title,$exam_type){
        $table='all_exams';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('exam_title',$exam_title);
        $this->db->where('exam_type',$exam_type);
        // $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_shift_exist($exam_id,$acedemic_session,$exam_start_time,$exam_end_time){
        $table='exam_shift';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('start_time',$exam_start_time);
        $this->db->where('end_time',$exam_end_time);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function get_exam_shifts($exam_id,$exam_shift_table){
        $table='exam_shift';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_course_exam_subject_exist($acedemic_session,$course_id,$subject){
        $table='exam_subjects_2';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->where('subject',$subject);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function check_course_exam_head_exist($acedemic_session,$course_id,$exam_head){
        $table='exam_heads_2';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->where('exam_head',$exam_head);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_subjects_data($course_id,$acedemic_session,$subjects_table){
        // $table='exam_subjects_2';
        $info=array();
        $this->db->select('*');
        $this->db->from($subjects_table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('subject_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function update_item_data($id,$data_array_update,$table){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_exam_heads_data($course_id,$acedemic_session,$exam_heads_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_heads_table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('head_order','ASC');
        // $this->db->where('subject',$subject);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function exam_data($exam_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_schedule_exist($exam_id,$course_id,$acedemic_session,$exam_paper,$exam_schedule_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_schedule_table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('exam_paper_name',$exam_paper);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_date_exist($exam_id,$acedemic_session,$exam_date,$exam_date_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_date_table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('exam_date',$exam_date);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_exam_schedule($exam_id,$exam_shift_id,$exam_date_id){
        $info=array();
        $this->db->select('*');
        $exam_schedule_table='exam_schedule';
        $this->db->from($exam_schedule_table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('exam_shift',$exam_shift_id);
        $this->db->where('exam_date_id',$exam_date_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_students_in_alpha_order(){
        $table='student'; 
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('student_name','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function student_course_data($course_id,$sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_course_student($course_id,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function course_students_list($course_id,$acedemic_session,$section){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->where('section',$section);
        $this->db->order_by('roll_no','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_subjects($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('subject_order','ASC');
        $this->db->where('course_id',$course_id);
        $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_active_subjects($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('subject_order','ASC');
        $this->db->where('course_id',$course_id);
        $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function student_course_info($sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_exam_heads($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->order_by('head_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function get_course_exam_heads($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('head_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_active_exam_heads($course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('head_order','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_log_item_data($sid,$ehid,$subject_id,$elog_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($elog_table);
        $this->db->where('sid',$sid);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('exam_head',$ehid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function students_exam_log($sid,$acedemic_session,$elog_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($elog_table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function update_elog_data($sid,$ehid,$subject_id,$data_array_update,$elog_table){
        $this->db->where('sid',$sid);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('exam_head',$ehid);
        $this->db->update($elog_table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_student_subjects($sid,$course_id,$acedemic_session){
        // $table='student_subjects';
        // $info=array();
        // $this->db->select('*');
        // $this->db->from($table);
        // $this->db->where('sid',$sid);
        // $this->db->where('course_id',$course_id);
        // $this->db->where('acedemic_session',$acedemic_session);
        // $this->db->where('status',1);
        // $info=$this->db->get()->result_array();
        // return $info;
        
        $sql="SELECT * FROM student_subjects WHERE sid='$sid' AND course_id='$course_id' AND acedemic_session='$acedemic_session'";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
    public function student_subject_info($sid,$course_id,$acedemic_session,$subjectid){
        $table='student_subjects';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('course_id',$course_id);
        $this->db->where('subject_id',$subjectid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_exam_head_for_session_for_exam($exam_title,$course_id,$acedemic_session,$exam_head_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_head_table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $this->db->where('exam_mode',$exam_title);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_remark_exist($remark,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('quote',$remark);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_course_exam_data($exam,$course,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam);
        $this->db->where('course_id',$course);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function update_course_exam_data($exam,$course,$data_array_update,$table){
        $this->db->where("exam_id",$exam);
        $this->db->where("course_id",$course);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_student_exam_data($sid,$exam_id,$course_id,$table){
         $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        // $this->db->where('course_id',$course_id);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_student_exam_data_new($sid,$exam_id,$class,$section,$acedemic_session,$table){
         $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function update_student_exam_data($sid,$exam_id,$course_id,$data_array_update,$table){
        $this->db->where("exam_id",$exam_id);
        $this->db->where("course_id",$course_id);
        $this->db->where("sid",$sid);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function update_student_course_data($sid,$course_id,$data_array_update,$table){
        $this->db->where("course_id",$course_id);
        $this->db->where("sid",$sid);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    public function update_student_course_data_1($sid,$acedemic_session,$course_id,$student_course_data_array,$student_course_data_table){
        $this->db->where("course_id",$course_id);
        $this->db->where("acedemic_session",$acedemic_session);
        $this->db->where("sid",$sid);
        $this->db->update($student_course_data_table,$student_course_data_array);
        return $this->db->affected_rows();
    }
    
    public function update_student_subjects_data($sid,$subject_id,$course_id,$acedemic_session,$student_subjects_table,$data_array_update){
        
        $this->db->where('subject_id',$subject_id);
        $this->db->where("course_id",$course_id);
        $this->db->where("sid",$sid);
        $this->db->where("acedemic_session",$acedemic_session);
        $this->db->update($student_subjects_table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function student_result($sid,$acedemic_session,$exam_id,$course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_student_subject_hic_data($acedemic_session,$course_id,$subject_id,$student_subjects_result){
        $info=array();
        $this->db->select('*');
        $this->db->from($student_subjects_result);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->limit(1); 
        $this->db->order_by('hy_total_marks','DESC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_result($exam_id,$acedemic_session,$course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('total_obtained_marks','DESC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_class_section_result($exam_id,$acedemic_session,$class,$section,$exam_result_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($exam_result_table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('percentage','DESC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function delete_student_subject($sid,$subjectid,$course_id,$acedemic_session,$table){
            $this -> db -> where('sid',$sid);
            $this -> db -> where('subject_id',$subjectid);
            $this -> db -> where('course_id',$course_id);
            $this -> db -> where('acedemic_session',$acedemic_session);
            $this -> db -> delete('student_subjects');
            return $this->db->affected_rows(); 
    }
    
    public function get_students_ac_session_by_course_and_class($acedemic_session,$class,$section){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        // $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('roll_no','ASC');
        $info=$this->db->get()->result_array();
        return $info; 
    }
    
    
    public function student_result_data($sid,$acedemic_session,$exam_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    // public function get_student_course_subjects($acedemic_session,$course_id,$sid,$subject_table){
    //     $this->db->select('*');
    //     $this->db->from('student_subjects');
    //     $this->db->join('exam_subjects_3', 'exam_subjects_3.id = student_subjects.subject_id');
    //     $this->db->where('student_subjects.sid',$sid);
    //     $this->db->where('student_subjects.course_id',$course_id);
    //     $this->db->where('student_subjects.acedemic_session',$acedemic_session);
    //     $query = $this->db->get();    
    // }
    
    
    public function check_new_subject($subject,$class,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('subject',$subject);
        $this->db->where('class',$class);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_class_subjects($class,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$class);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_hic_data($hic_subject_id,$class,$section,$acedemic_session){
        $table="student_subjects";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('hic_subject_id',$hic_subject_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('hy_total_marks','DESC');
        $this->db->limit(1); 
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_hic_data_second_term($hic_subject_id,$class,$section,$acedemic_session){
        $table="student_subjects";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('hic_subject_id',$hic_subject_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('second_term_marks','DESC');
        $this->db->limit(1); 
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_hic_data_annual($hic_subject_id,$class,$section,$acedemic_session){
        $table="student_subjects";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('hic_subject_id',$hic_subject_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('annual_total_marks','DESC');
        $this->db->limit(1); 
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_hic_data_annual_manual($subject_id,$class,$section,$acedemic_session){
        $table="student_subjects";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('annual_total_marks','DESC');
        $this->db->limit(1); 
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_hic_data_manual($subject_id,$class,$section,$acedemic_session){
        $table="student_subjects";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('hy_total_marks','DESC');
        $this->db->limit(1); 
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_hic_data_manual_new($subject_id,$class,$section,$acedemic_session){
        $table="student_subjects";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('subject_id',$subject_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('second_term_marks','DESC');
        $this->db->limit(1); 
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_exam_list_data($exam_title,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_title',$exam_title);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_course_exam_data($exam_id,$exam_title,$acedemic_session,$course_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('exam_id',$exam_id);
        $this->db->where('exam_title',$exam_title);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function update_exam_data($exam_id,$acedemic_session,$course_id,$data_array_update,$admin_card_table){
        $this->db->where("exam_id",$exam_id);
        $this->db->where("acedemic_session",$acedemic_session);
        $this->db->where("course_id",$course_id);
        $this->db->update($admin_card_table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_course_exam_admit_card($course_id,$exam_id,$acedemic_session,$admit_card_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($admit_card_table);
        $this->db->where('exam_id',$exam_id);
        // $this->db->where('exam_title',$exam_title);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function get_students_ac_session_by_course_and_class_new($acedemic_session,$class,$section){
        // $table='student_courses_data';
        // $info=array();
        // $this->db->select('*');
        // $this->db->from($table);
        // $this->db->where('class',$class);
        // $this->db->where('section',$section);
        // $this->db->where('acedemic_session',$acedemic_session);
        // $this->db->order_by('roll_no','ASC');
        // $info=$this->db->get()->result_array();
        // return $info;
        
        $sql="SELECT scd.sid,scd.course_id,scd.class,scd.section,scd.roll_no,scd.height,scd.weight,student.student_name,student.father_name,student.dob,student.sch_no FROM student_courses_data as scd LEFT JOIN student ON scd.sid=student.id WHERE scd.acedemic_session='$acedemic_session' AND scd.class='$class' AND scd.section='$section' AND student.status=1 ORDER BY scd.roll_no ASC";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
    public function get_class_course_id($class,$course_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($course_table);
        $this->db->where('course',$class);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_exam_subject($class,$subject){
        $table="exam_subject_master";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$class);
        $this->db->where('subject',$subject);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_exams($acedemic_session,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    //  
    
}
