<?php
class ImportModel extends CI_Model {
    
    public function get_students_in_alpha_order($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('student_name','ASC');
        $info=$this->db->get()->result_array();
        return $info;     
    }
    
    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id','DESC');
        $info=$this->db->get()->result_array();
        return $info;  
    }

    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }    
    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_doc_data($doc_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('doc_id',$doc_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_doc_students_combined_data($doc_id){
        $sql="SELECT import_students.*,courses.id as current_course_id FROM import_students LEFT JOIN courses ON courses.course=import_students.class WHERE import_students.doc_id='$doc_id'";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }

    public function get_documents_data_combined(){
        $sql="SELECT docs.*,academic_session_details.year_long,college_master.college_name,college_master.code as college_code,course_stream.course_stream,course_stream.course_stream_code,courses.course,courses.part,courses.part_type FROM import_documents as docs LEFT JOIN academic_session_details ON docs.academic_session=academic_session_details.id LEFT JOIN college_master ON docs.college_id=college_master.id LEFT JOIN course_stream ON docs.course_stream_id=course_stream.id LEFT JOIN courses ON courses.id=docs.course_id ORDER BY docs.id DESC";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }

    public function get_doc_student_count($doc_id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->where('doc_id',$doc_id);
        $this->db->from($table);
        return $this->db->get()->num_rows();
    }

    public function check_student_data($student_name,$father_name,$aadhar_no){
        $table="student";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('student_name',$student_name);
        $this->db->where('father_name',$father_name);
        $this->db->where('aadhar_no',$aadhar_no);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    
    public function check_student_exists($student_name,$mobile_no,$dob){
        $table="student";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('student_name',$student_name);
        $this->db->where('contact_no',$mobile_no);
        $this->db->where('dob',$dob);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function update_item_data($id,$table,$data_array_update){
        $this->db->where("id",$id);
        // $this->db->where('date',$date);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }

    public function get_subject_data($course_stream_id,$subject_1,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('subject',$subject_1);
        $this->db->where('course_stream_id',$course_stream_id);
        $info=$this->db->get()->result_array();
        return $info;
    }

}