<?php
class AccountsModel extends CI_Model {
    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    
    public function update_item_data($id,$data_array_update,$table){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);    
        return $this->db->affected_rows();        
    }
    

    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }
    
    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    public function get_active_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    
    public function get_ledger_data($acedemic_session,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_month_data($month,$acedemic_session,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('month',$month);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('date','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_fee_received($acedemic_session,$table){
        $info=array();
        $this->db->select('month,year,received_amount');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('fee_no','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
}