<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Teacher extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('StudentModel');
        $this->load->model('AttendenceModel');
        $this->load->model('NewFeeModel');
        $this->load->model('CalenderModel');
        $this->load->model('WelcomeModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url'));
        $this->load->library('session');
        // $this->load->library('Pdf');
    }

    public function index(){
    
    }
    public function daily_attendence(){
        if($this->session->userdata('user')!=1){
            redirect(base_url().'login/');
        }     
        $acedemic_session=$this->session->userdata('acedemic_session');
        $tid = $this->session->userdata('tid');	
        $section = $this->session->userdata('class_teacher_section');	
        $table='attendence';
        $date = date('Y-m-d');
        $class=$this->session->userdata('class_teacher');
        $check_closed =$this->AttendenceModel->check_closed($class,$section,$date,$table);
        if($check_closed){
            redirect(base_url().'teacher/attendence');	
        }
        // else{	


        $today=date('D',strtotime($date));
        $holiday=0;
        $sunday=0;
        if($today=='Sun'){
            $sunday=$sunday + 1;    
        }
        $check_holiday=$this->AttendenceModel->check_holiday($date);
        if($check_holiday){
            $holiday=$holiday + 1;    
        }

        // $check_marked_pending_attendance=$this->AttendenceModel->marked_pending_attendance($acedemic_session,$tid);
        $check_marked_pending_attendance=$this->AttendenceModel->marked_pending_attendance_by_class($acedemic_session,$class,$section);
        $marked_pending=0;
        $pending_atd_date='';
        $today_date=date('Y-m-d');
        if($check_marked_pending_attendance){
            foreach($check_marked_pending_attendance as $pending_atd){
                $pending_atd_date=date('Y-m-d',strtotime($pending_atd['date']));    
                $marked_pending=$marked_pending + 1;
            }
            // $marked_pending=1;    
        }
        if($sunday==1 || $holiday==1){
            $this->load->view('erp/header');
            $this->load->view('erp/sidebar');
            $this->load->view('erp/teachers/holiday-view'); 
            $this->load->view('erp/footer'); 
        }
        else if($marked_pending == 1 && $pending_atd_date != $today_date){
            $this->load->view('erp/header');
            $this->load->view('erp/sidebar');
            $this->load->view('erp/teachers/marked-pending-attendance');
            $this->load->view('erp/footer'); 
        }else{
            $db_check_attendence = $this->AttendenceModel->class_attendence($class,$section,$date,$table);
            if($db_check_attendence > 0){
            
            }else{
                $all_students_data=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);	
                foreach ($all_students_data as $data ) {
                    $val = 'p';
                    $sid =$data['id'];

                    $dd=date('d',strtotime($date));
                    $mm=date('m',strtotime($date));
                    $yy=date('Y',strtotime($date));
                    $cat=date('Y-m-d H:i:s');

                    $data_attendence = array("acedemic_session"=>$acedemic_session,"sid"=>$sid,"date"=>$date,"status"=>$val,"class"=>$class,"section"=>$section,"teacher_id"=>$tid,"day"=>$dd,"month"=>$mm,"year"=>$yy,"cat"=>$cat);
                    $db_attendence = $this->AttendenceModel->attendence($table,$data_attendence);
                }
            }
            $this->load->view('erp/header');
            $this->load->view('erp/sidebar');
            $this->load->view('erp/teachers/daily-attendence');
            $this->load->view('erp/footer');    
        }
    }


    public function getallstudent(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        // $data=$this->AttendenceModel->student_by_class($acedemic_session,$class,$section);	
        $data=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);	
        $date = date('Y-m-d');
        $table='attendence';
        $count =0;
        if($data){
            foreach($data as $students){
                // $student_table='student';
                // $students_info=$this->AttendenceModel->get_item_data($students['sid'],$student_table);
                // if($students_info){
                //     foreach ($students_info as $row){

                        $sid =$students['id'];     
                        $count++;
                        echo "<tr>";
                        echo "<td>".$count."</td>";
                        echo "<td>".$students['roll_no']."</td>";
                        echo "<td>".$students['sch_no']."</td>";
                        // echo "<td>".$row['class']."</td>";
                        echo "<td>".$students['student_name']."</td>";
                        echo "<td>".$students['father_name']."</td>";
                        echo "<td><button class='btn btn-danger btn-sm absent_button active' active_attr='a' classs='".$class."' db_id='".$sid."'>Absent</button></td>";
                        echo "<td>";
                        $attendence_data =  $this->AttendenceModel->student_attendence_by_id($sid,$class,$section,$date,$table);
                        if ($attendence_data){
                            foreach ($attendence_data as $attendence){
                                if($attendence['status']=='a'){
                                    echo "<button class='btn btn-sm btn-danger  absent' active_attr='a' db_id='".$sid."'>Absent</button>";
                                }else if($attendence['status']=='p'){
                                    echo "<button class='btn btn-sm btn-success present' active_attr='p' db_id='".$sid."'>Present</button>";
                                }
                            }

                        }
                        echo "</td>";
                        echo "</tr>";
                //     }
                // }
            }
        }else{
            echo "H1 error";
        }

    }
    
    
    public function getallstudent_1(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        // $class = $this->session->userdata('class_teacher');
        // $section = $this->session->userdata('class_teacher_section');
        $class=trim($_POST['e_class']);
        $section =trim($_POST['section']);
        $data=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);	
        $date = date('Y-m-d');
        $table='attendence';
        $count =0;
        if($data){
            foreach($data as $students){
                $student_table='student';
                $students_info=$this->AttendenceModel->get_item_data($students['sid'],$student_table);
                if($students_info){
                    foreach ($students_info as $row){

                        $sid =$row['id'];     
                        $count++;
                        echo "<tr>";
                        // echo "<td>".$count."</td>";
                        echo "<td>".$row['roll_no']."</td>";
                        echo "<td>".$row['sch_no']."</td>";
                        // echo "<td>".$row['class']."</td>";
                        echo "<td>".$row['student_name']."</td>";
                        // echo "<td>".$row['father_name']."</td>";
                        echo "<td><button class='btn btn-danger btn-sm absent_button active' active_attr='a' classs='".$class."' db_id='".$row['id']."'>Absent</button></td>";
                        echo "<td>";
                        $attendence_data =  $this->AttendenceModel->student_attendence_by_id($sid,$class,$section,$date,$table);
                        if ($attendence_data){
                            foreach ($attendence_data as $attendence){
                                if($attendence['status']=='a'){
                                    echo "<button class='btn btn-sm btn-danger  absent' active_attr='a' db_id='".$attendence['sid']."'>Absent</button>";
                                }else if($attendence['status']=='p'){
                                    echo "<button class='btn btn-sm btn-success present' active_attr='p' db_id='".$attendence['sid']."'>Present</button>";
                                }
                            }

                        }
                        echo "</td>";
                        echo "</tr>";
                    }
                }
            }
        }else{
            echo "H1 error";
        }

    }


    public function getPresentStudentsinClass(){
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        $date = date('Y-m-d');
        $table='attendence';  
        $status='p';
        $db_check_present = $this->AttendenceModel->class_attendence_data($class,$section,$date,$table,$status);
        if($db_check_present>0){
            echo $db_check_present; 
        }
    }
    public function getAbsentStudentsinClass(){
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        $date = date('Y-m-d');
        $table='attendence';  
        $status='a';
        $db_check_absent = $this->AttendenceModel->class_attendence_data($class,$section,$date,$table,$status);
        if($db_check_absent>0){
            echo $db_check_absent; 
        }
    }




    public function final_attendence(){
        $table='attendence';
        $date = date('y-m-d');
        $acedemic_session=$this->input->post('acedemic_session');
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        $check_closed =$this->AttendenceModel->check_closed($class,$section,$date,$table);
        if($check_closed>0){
            redirect(base_url().'teacher/attendence');	
        }	
        $class_teacher = $this->session->userdata('tid');
        $db_check_attendence = $this->AttendenceModel->class_attendence($class,$section,$date,$table);
        if($db_check_attendence>0){
        }else{
            $data_array=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);	
            foreach ($data_array as $data){
                $val = 'p';
                $sid =$data['sid'];
                $data_attendence = array("acedemic_session"=>$acedemic_session,"sid"=>$sid,"date"=>$date,"status"=>$val,"class"=>$class,"section"=>$section,"teacher_id"=>$class_teacher);
                $db_attendence = $this->AttendenceModel->attendence($table,$data_attendence);
            }
        }


        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/final-attendence',$db_check_attendence);
        $this->load->view('erp/footer');
    }


    public function getallstudents(){    
        $acedemic_session=$this->session->userdata('acedemic_session');
        $class=$this->session->userdata('class_teacher');
        $section =$this->session->userdata('class_teacher_section');
        $data=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);    
        $student_table='student';
        $count =0;
        foreach($data as $students){
            
            $students_info=$this->AttendenceModel->get_item_data($students['sid'],$student_table);
            if($students_info){
    

                $date = date('y-m-d');
                $table='attendence';
                
                foreach ($students_info as $row){
                    $count=$count + 1;    
                    $sid=$row['id'];    
                    $class="";
                    $at_status="";
                    $attendence_data =  $this->AttendenceModel->student_attendence_by_id($sid,$class,$section,$date,$table);
                    if($attendence_data) {
                        foreach ($attendence_data as $attendence) {    
                            $at_status=$attendence['status'];
                            if($attendence['status']=='p'){
                                $class="green";
                                // echo "<tr class='green'>";
                            }else if($attendence['status']=='a'){
                                // echo "<tr class='red'>";
                                $class="red";
                            }
                        }
                    }
                    echo "<tr class='".$class."'>";
                    echo "<td>".$count."</td>";
                    echo "<td>".$row['sch_no']."</td>";
                    echo "<td>".$row['student_name']."</td>";

                echo "<td>".$row['father_name']."</td>";
                // echo "<td>".$row['class']."</td>";
                    echo "<td id='btn'>
                    <button class='btn btn-sm btn-danger absent_button active' active_attr='a' classs='".$row['class']."' db_id='".$row['id']."'>Absent</button>&nbsp;&nbsp;<button class='btn btn-sm btn-success present_button active' active_attr='p' classs='".$row['class']."' db_id='".$row['id']."'>Present</button></td>";
                    echo "<td id='btn'>";
                    $sid =$row['id'];   
                    
                            if($at_status == 'a'){
                                echo "<button class='btn btn-sm btn-danger  absent' active_attr='a' db_id='".$row['id']."'>Absent</button>";
                                
                            }else if($at_status == 'p'){
                                echo "<button class='btn btn-sm btn-success present' active_attr='p' db_id='".$row['id']."'>Present</button>";
                            }
                            // echo $at_status;
                      
                    echo "</td>";   

                    echo "</tr>";
                }
            }
        }
    }


    public function markin(){
        $val = $_POST['val'];
        $id = $_POST['id'];
        $table = "attendence";
        // $class = $this->session->userdata('class_teacher');
        // $section =$this->session->userdata('class_teacher_section');
        $date = date('Y-m-d');
        
        $db_set_attendence = $this->AttendenceModel->set_attendence($val,$id,$table,$date);
        if($db_set_attendence){
            echo $db_set_attendence;
        }
        
        
        // $data_array=array("sid"=>$id,"class"=>$class,"date"=>$date,"status"=>$val);
        // $db_check_attendence =  $this->AttendenceModel->check_student_attendence($id,$date,$table);
        // if($db_check_attendence){
        //     $check_closed =$this->AttendenceModel->check_closed($class,$section,$date,$table);
        //     if($check_closed){
        //         // redirect(base_url().'admin/');
        //         echo "already Closed";
        //     }else{
        //         $db_set_attendence = $this->AttendenceModel->set_attendence($val,$id,$table,$date);
        //     }  
        // }else{
        //     echo "NA";
        // }
        
        
    }


    public function attendence(){
        $class=$this->session->userdata('class_teacher');
        $section =$this->session->userdata('class_teacher_section');
        $date = date('y-m-d');			
        $table='attendence';	
        $check_closed=$this->AttendenceModel->check_closed($class,$section,$date,$table);
        if($check_closed>0){
            // echo "Alredy Closed";
        }else{
            $close_attendence=$this->AttendenceModel->close_attendence($class,$section,$date,$table);
            if($close_attendence){
                // echo "closed";
            }else{

            }
        }
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/attendence');
        $this->load->view('erp/footer');
    }

    public function getattendence(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        $date = date('y-m-d');
        $table='attendence';
        $count =0;
        $data=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);   
        foreach($data as $students){
            $sid=$students['id'];
            
            
            // $student_table='student';
            // $students_info=$this->AttendenceModel->get_item_data($students['sid'],$student_table);
            // if($students_info){
    
            //     foreach ($students_info as $row) {
                    
                    $attendence_data =  $this->AttendenceModel->student_attendence_by_id($sid,$class,$section,$date,$table); 
                    foreach ($attendence_data as $attendence) {
                        if($attendence['status']=='a'){
                            $count++;   
                            echo "<tr class='red'>";
                                echo "<td>".$count."</td>";
                                echo "<td>".$students['sch_no']."</td>";
                                echo "<td>".$students['student_name']."</td>";
                                echo "<td>".$students['father_name']."</td>";
                                // echo "<td>".$row['class']."</td>";
                                echo "<td>";
                                    echo "<button class='btn btn-sm btn-danger  absent' active_attr='a' db_id='".$attendence['sid']."'>Absent</button>";
                                echo "</td>"; 
                            echo "</tr>";
                        }
                    }    
                // }
                // foreach ($students_info as $row) {
                    // $sid=$row['id'];
                    // $attendence_data =  $this->AttendenceModel->student_attendence_by_id($sid,$class,$section,$date,$table); 
                    foreach ($attendence_data as $attendence) {    
                        if($attendence['status']=='p'){
                            $count++;   
                            echo "<tr class='green'>";
                                echo "<td>".$count."</td>";
                                echo "<td>".$students['sch_no']."</td>";
                                echo "<td>".$students['student_name']."</td>";
                                echo "<td>".$students['father_name']."</td>";
                                // echo "<td>".$row['class']."</td>";
                                echo "<td>";
                                    echo "<button class='btn btn-sm btn-success  absent' active_attr='a' db_id='".$attendence['sid']."'>Present</button>";
                                echo "</td>"; 
                            echo "</tr>";
                        }
                    }    
                // }
            // }
        }
    }


    public function my_class_fee_defaulters(){
        if($this->session->userdata('class_teacher')!=''){
            $this->load->view('erp/header');
            // $this->load->view('erp/staff-nav');
            $this->load->view('erp/new/sidebar');
            $this->load->view('erp/teachers/my-class-fee-defaulters');
            $this->load->view('erp/footer');
        }       
    }


    public function attendance_history(){
        if($this->session->userdata('class_teacher')!=''){
            $this->load->view('erp/header');
            // $this->load->view('erp/staff-nav');
            $this->load->view('erp/sidebar');
            // $this->load->view('erp/teachers/attendance-history');
            $this->load->view('erp/calender/attendance_calender');
            $this->load->view('erp/footer');
        }
    }

    public  function draw_attendance_calendar(){
       // echo "".$month."-".$year."";  
	   /* draw table */

        $month =$_POST['month'];
        $year =$_POST['year'];
        $d=1;

        $month_name = date("F", mktime(0, 0, 0, $month, 10));	
        $calendar='';
        $calendar .='<div class="table-responsive">';
        $calendar.="".$month_name."-".$year."";  
	    $calendar .= '<table  class="table table-bordered calendar">';

	    /* table headings */
	    $headings = array('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
	    $calendar.= '<tr class="calendar-row"><td class="calendar-day-head">'.implode('</td><td class="calendar-day-head">',$headings).'</td></tr>';

    	/* days and weeks vars now ... */
	    $running_day = date('w',mktime(0,0,0,$month,1,$year));
	    $days_in_month = date('t',mktime(0,0,0,$month,1,$year));
	    $days_in_this_week = 1;
	    $day_counter = 0;
	    $dates_array = array();
    
	    /* row for week one */
	    $calendar.= '<tr class="calendar-row">';
    
	    /* print "blank" days until the first of the current week */
	    for($x = 0; $x < $running_day; $x++):
		$calendar.= '<td class="calendar-day-np"> </td>';
		$days_in_this_week++;
    	endfor;

	    /* keep going with days.... */

        for($list_day = 1; $list_day <= $days_in_month; $list_day++):
            $sunday_active='';
            $holiday_active='';
            $is_marked='';
            $is_closed='';
            $check_sunday=$this->CalenderModel->check_sunday($list_day,$month,$year);
            if($check_sunday == "Sun"){
                $sunday_active=1;
            }    
            $check_holiday=$this->CalenderModel->check_holiday_date($list_day,$month,$year);
            if($check_holiday){
                $holiday_active=1;    
            }			    
            $tid=$this->session->userdata('tid');
            $day1=$list_day + 1;
            $check_attendance_data=$this->AttendenceModel->attendance_by_tid($list_day,$month,$year,$tid);
            if($check_attendance_data){
                foreach($check_attendance_data as $atd_data){    
                    $is_closed=$atd_data['closed'];   
                    $is_marked=1;
                }
            }else{
                $is_marked=0;   
            }
            if($holiday_active==1 || $sunday_active==1){	    
                $calendar.= '<td class="calendar-day bg-danger text-white" style="border:2px solid #fff !important;">';
            }else if($is_marked ==1 && $is_closed==1){
                $calendar.= '<td class="calendar-day bg-success text-white">';
            }else if($is_marked ==1 && $is_closed==0){
                $calendar.= '<td class="calendar-day bg-warning text-white">';
            }else if($is_marked ==0){
                $calendar.= '<td class="calendar-day bg-info text-white">';
            }else{
                $calendar.= '<td class="calendar-day">';    
            }

            $calendar.='<a href="'.base_url().'Teacher/attendance_log/'.$list_day.'/'.$month.'/'.$year.'">';
			/* add in the day number */
			
            $check_holiday=$this->CalenderModel->check_holiday_date($list_day,$month,$year);
            if($check_holiday){
                foreach($check_holiday as $holiday){
                    $calendar .='<div class="event  text-white text-center bg-danger font-weight-bold width:70%;">'.$holiday['holiday_detail'].'</div>';    
                }
            }
			    
            $calendar.= '<div class="day-number">'.$list_day.'</div>';

			/** QUERY THE DATABASE FOR AN ENTRY FOR THIS DAY !!  IF MATCHES FOUND, PRINT THEM !! **/
			$calendar.= str_repeat('<p> </p>',2);
			
            $calendar.= '</a></td>';

		    if($running_day == 6):
			    $calendar.= '</tr>';
			    if(($day_counter+1) != $days_in_month):
				    $calendar.= '<tr class="calendar-row">';
			    endif;
			    $running_day = -1;
			    $days_in_this_week = 0;
		    endif;
		    $days_in_this_week++; $running_day++; $day_counter++;
	    endfor;

	    /* finish the rest of the days in the week */
	    if($days_in_this_week < 8):
		    for($x = 1; $x <= (8 - $days_in_this_week); $x++):
			    $calendar.= '<td class="calendar-day-np"> </td>';
		    endfor;
	    endif;

	    /* final row */
	    $calendar.= '</tr>';

	    /* end the table */
        // 	$calendar.= '</table></div>';
    	
        // 	$calendar .='<div class="table-responsive">
        // 	<table class="table table-bordered table-striped"><tbody>';
        // $check_holiday=$this->CalenderModel->get_holidays_in_month($month,$year);
        // if($check_holiday){
        // 	foreach($check_holiday as $holiday){
        // 	$calendar .='<tr>
        // 	<th>'.date('d-M-Y',strtotime($holiday['holiday_date'])).'</th>
        // 	<td>'.$holiday['holiday_detail'].'</td>
        // 	</tr>';
        // 	}
        // }
        // 	$calendar .='</tbody>
        // 	</table
        // 	<div>';
	
	
	    /* all done, return result */
	    echo $calendar;
    }
    
    
    public function attendance_log($day,$month,$year){
        if($this->session->userdata('class_teacher')!=''){
            $this->load->view('erp/header');
            // $this->load->view('erp/staff-nav');
            $this->load->view('erp/sidebar');
            $this->load->view('erp/teachers/attendance-history');
            // $this->load->view('erp/calender/attendance_calender');
            $this->load->view('erp/footer');
        }
    }    

    public function update_year(){
        $year=2020;
        $update_year=$this->AttendenceModel->update_year($year);
        if($update_year){
            echo $update_year;    
        }
    }
    
    
    
    public function attendance_detail($date){
        // echo $date;
        // if($this->session->userdata('class_teacher')!=''){
        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/attendance-detail');
        $this->load->view('erp/footer');    
    }
 
    public function getPresentStudentsinClass_for(){
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        // $date = date('y-m-d');
        $date=$_POST['date'];
        $table='attendence';  
        $status='p';
        $db_check_present = $this->AttendenceModel->class_attendence_data($class,$section,$date,$table,$status);
        if($db_check_present>0){ echo $db_check_present; }    
    } 


    public function getAbsentStudentsinClass_for(){
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        // $date = date('y-m-d');
        $date=$_POST['date'];
        $table='attendence';  
        $status='a';
        $db_check_absent = $this->AttendenceModel->class_attendence_data($class,$section,$date,$table,$status);
        //  if($db_check_absent>0){echo $db_check_absent; }
        echo $db_check_absent; 
    }
    

    public function getallstudent_for(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        $class = $this->session->userdata('class_teacher');
        $section = $this->session->userdata('class_teacher_section');
        $data=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);	
        $date=date("Y-m-d",strtotime($_POST['date']));
    
        $count =0;
        foreach ($data as $row) {	
            $sid =$row['id'];     
        
            $student_table='student';
            $count=$count + 1;
            $get_student_info=$this->AttendenceModel->get_item_data($sid,$student_table);
            if($get_student_info){
                foreach($get_student_info as $student){
                $sid =$student['id'];   
                echo "<tr>";
                echo "<td>".$count."</td>";
                echo "<td>".$student['sch_no']."</td>";
                // echo "<td>".$row['class']."</td>";
                echo "<td>".$student['student_name']."</td>";
                echo "<td>".$student['father_name']."</td>";
                echo "<td>";
                    echo "<button class='btn  btn-sm btn-danger absent_button active' active_attr='a' classs='".$row['class']."' db_id='".$sid."'>Absent</button>";
                    echo "&nbsp; &nbsp;";
                    echo "<button class='btn btn-sm btn-success present_button active' active_attr='p' classs='".$row['class']."' db_id='".$sid."'>Present</button>";
                echo "</td>";
                echo "<td>";
                $date_1=date('Y-m-d',strtotime($date));
                $table='attendence';
                $attendence_data=$this->AttendenceModel->student_attendence_by_id_1($sid,$date_1,$table);
                    // echo $sid;
                    // echo $table;
                    if($attendence_data){
                        foreach ($attendence_data as $attendence) {  
                            $at_status=$attendence['status'];
                            if($at_status =='a'){
                                echo "<button class='btn btn-sm btn-danger  absent' active_attr='a' db_id='".$attendence['sid']."'>Absent</button>";
                            }else if($at_status =='p'){
                                echo "<button class='btn btn-sm btn-success present' active_attr='p' db_id='".$attendence['sid']."'>Present</button>";
                            }
                        }

                    }else{ echo $date_1." ".$sid; }
                    echo "</td>";	
                    echo "</tr>";
   
                }
            }
        }
    }    

    public function markin_old_attendance(){
        $val = $_POST['val'];
        $id = $_POST['id'];
        $table = $_POST['table'];
        $class = $this->session->userdata('class_teacher');
        $section =$this->session->userdata('class_teacher_section');
        // $date = date('y-m-d');
        $date=$_POST['date'];
        $data_array=array("sid"=>$id,"class"=>$class,"date"=>$date,"status"=>$val);
        $db_check_attendence =  $this->AttendenceModel->check_student_attendence($id,$date,$table);
        if($db_check_attendence>0){
            $check_closed =$this->AttendenceModel->check_closed($class,$section,$date,$table);
            if($check_closed){
                // redirect(base_url().'admin/');
                echo "already Closed";
            }else{
                $db_set_attendence = $this->AttendenceModel->set_attendence($val,$id,$table,$date);
                echo "Updated";
            }  
        }else{
            echo "No Record Found";
        }
    }


    public function close_old_attendance(){
        $note=$_POST['note'];
        $date=date('Y-m-d',strtotime($_POST['date']));
        $table=$_POST['table'];
        $cat=date('Y-m-d H:i:s');
        $class = $this->session->userdata('class_teacher');
        $section =$this->session->userdata('class_teacher_section');
        $close_attendence=$this->AttendenceModel->close_old_attendance($class,$section,$date,$table,$note,$cat);
        if($close_attendence){
            redirect(base_url().'teacher/daily_attendence/');    
        }
    }


    public function mark_old_attendance($date){
        $acedemic_session=$this->session->userdata('acedemic_session');
        if($this->session->userdata('user')!=1){ redirect(base_url().'login/'); }
        $tid = $this->session->userdata('tid');	
        $section = $this->session->userdata('class_teacher_section');	
        $class=$this->session->userdata('class_teacher');
        $table='attendence';
        // $date = date('y-m-d');
        // $date=$this->uri->segment('3');
        $check_closed =$this->AttendenceModel->check_closed($class,$section,$date,$table);
        if($check_closed){
        // redirect(base_url().'teacher/attendence');	
        }	
        $db_check_attendence=$this->AttendenceModel->class_attendence($class,$section,$date,$table);
    
    
    
        if($db_check_attendence>0){
        }else{
            $data_array=$this->AttendenceModel->student_by_class_and_section_combined($acedemic_session,$class,$section);	
            foreach ($data_array as $data ) {
                $val = 'p';
                $sid =$data['id'];
        
                $dd=date('d',strtotime($date));
                $mm=date('m',strtotime($date));
                $yy=date('Y',strtotime($date));
                $cat=date('y-m-d H:i:s');

                $data_attendence = array("sid"=>$sid,"date"=>$date,"status"=>$val,"class"=>$class,"section"=>$section,"teacher_id"=>$tid,"day"=>$dd,"month"=>$mm,"year"=>$yy,"cat"=>$cat);
                $db_attendence = $this->AttendenceModel->attendence($table,$data_attendence);
            }
        }

        $this->load->view('erp/header');
        // $this->load->view('erp/staff-nav');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/mark-old-attendance');
        $this->load->view('erp/footer');
    }
    
    public function abcd(){
        echo $daystr=date('D');
    }
    
    public function check_sunday($list_day,$month,$year){

        // $day=$this->uri->segment('3') + 1;
        // $month=$this->uri->segment('4');
        // $year=$this->uri->segment('5');
        $d=unixtojd(mktime(0,1,0,$month,$list_day,$year));
        // print_r(cal_from_jd($d,CAL_GREGORIAN));
        $ddd=array(cal_from_jd($d,CAL_GREGORIAN));
        foreach($ddd as $dd){
            echo $daystr=date('D',strtotime($dd['date']));
            // echo $daystr=date('D',strtotime($log_date));
            // if($daystr =="Sun"){
            // return 1;
            // }else{
            // return 0;    
            // }
            // echo $log_date;
        }

    
    }

}
?>