<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Staff extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->database();  
        $this->load->model('UserModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewFeeModel');
        $this->load->library('session');
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
    }  
    public function index(){
        $data['success']=""; $data['error']="";   
        $eid="";
        $mobile_no="";
        $status="";
        $login_at="";
        $name="";
    
        if(isset($_POST['login_btn'])){
            $username=$this->input->post('username');   
            $password=$this->input->post('password');
            $latd=$this->input->post('latd');
            $lotd=$this->input->post('lotd');
            $ip=$this->input->post('ip');
            $session_id=mt_rand(999999,9999999);
            $cat=date('Y-m-d-h-i-s');
            $check_user=$this->UserModel->check_user($username,$password);
            if($check_user){
                foreach($check_user as $user){
                    $eid=$user['id'];
                    $mobile_no=$user['mobile'];
                    $status=$user['status'];
                    $name=$user['name'];    
                }    
                if($status==1){
                    // array("longtitude"=>$lotd,"lattitude"=>$latd,"ip"=>$ipadd,"cat"=>$cat,"user_id"=>$userid);
                    $data_array=array("user_id"=>$eid,"session_id"=>$session_id,"lattitude"=>$latd,"longtitude"=>$lotd,"ip"=>$ip,"cat"=>$cat);    
                    $add_log_data=$this->UserModel->add_log($data_array);
                    if($add_log_data){
                        $login_at=date('d-m-Y,h-i-s');   
                        $this->session->set_userdata('session_id',$session_id);
                        $this->session->set_userdata('user',$status);    
                        $this->session->set_userdata('mobile_number',$mobile_no);
                        $this->session->set_userdata('name',$name);
                        $this->session->set_userdata('tid',$eid);
                        $this->session->set_userdata('last_login',$login_at);


                    }
                }    
                redirect(base_url().'home/dashboard');    
            }else{
                $data['error']="invalid login credentials";    
            }
        }    
        $this->load->view('front/header');
        // $this->load->view('front/navbar');
        $this->load->view('front/login',$data);
        $this->load->view('front/footer-content');
        $this->load->view('front/footer');
    }

    public function dashboard(){
        if($this->session->userdata('user')!=1){
            redirect(base_url().'home/');
        }    


        // $this->load->view('front/header');
        // $this->load->view('front/navbar');

        $this->load->view('new-admin/header');
        $this->load->view('new-admin/front-sidebar');
        $this->load->view('front/dashboard');
        // $this->load->view('front/daily-attendance');

        $eid=$this->session->userdata('tid');
        $date=date('Y-m-d');
        $check_day_status=$this->UserModel->check_day_attendance($date,$eid);
        $markout_status=0;
        if($check_day_status){
            foreach($check_day_status as $data1){  
                $markout_status=$data1['is_markout'];    
            }
            if($markout_status==0){
                $this->load->view('front/attendance');         
            }
        }
        $this->load->view('front/daily-log');
        $this->load->view('new-admin/footer');

        // $this->load->view('front/footer-content');
        // $this->load->view('front/footer');
    }
    public function logout(){
        $this->session->sess_destroy();
        redirect(base_url().'home/');
    }

    public function markin(){
        if($this->session->userdata('user')!=1){
            redirect(base_url().'home/');
        }    

        $latd=$_POST['latdd'];
        $lotd=$_POST['lotd'];
        $ipadd=$_POST['ipaddress'];
        $cat=date('Y-m-d-h-i-s');
        $userid = $this->session->userdata('tid');
        echo $latd;
        $data_array=array("longtitude"=>$lotd,"lattitude"=>$latd,"ip"=>$ipadd,"cat"=>$cat,"user_id"=>$userid);
        $add_log=$this->UserModel->add_log($data_array);
        if($add_log){
            echo "success";    
        }
    }

    public function start_day(){
        // if($this->session->userdata('user')!=1){
        // redirect(base_url().'home/');
        // }    
    
        $ip=$_POST['ip'];
        $latd=$_POST['latd'];
        $lotd=$_POST['lotd'];
        $place="School";
        $note="";
        $table=$_POST['table'];
        $cat=date('Y-m-d-h-i-s');
        $date=date('Y-m-d');
        $time=date("H:i:s");
        $table_check_in='activities';
        $eid=$this->session->userdata('tid');
        // $session_id=$this->session->userdata('session_id');
        $data_array=array("markInDate"=>$date,"markInTime"=>$time,"userId"=>$eid,"latitude"=>$latd,"longitude"=>$lotd,"createdDateTime"=>$cat,"ip"=>$ip,"status"=>1);
    
        $check_day_status=$this->UserModel->check_day_attendance($date,$eid);
        if($check_day_status){
            
        }else{
            $start_day=$this->UserModel->start_day($data_array,$table);  
            if($start_day){
                
                $data_array_check_in=array("cat"=>$cat,"latd"=>$latd,"lotd"=>$lotd,"ip"=>$ip,"eid"=>$eid,"place"=>$place,"note"=>$note,"checkin_time"=>$time,"checkin_date"=>$date,"status"=>0);
                $check_active_checkin=$this->UserModel->check_active_checkin($eid,$date);
                if($check_active_checkin){
                    // foreach($check_active_checkin as $check_in_data){
                    // } 
                }else{
                    $new_check_in=$this->UserModel->new_check_in($data_array_check_in,$table_check_in);
                    if($new_check_in){
                        echo $new_check_in;    
                    }
                }
                
                
                echo "Added Successfully";    
            }
        }
    }
    public function new_day_start(){
    // if($this->session->userdata('user')!=1){
    // redirect(base_url().'home/');
    // }    

    // $this->load->view('front/header');
    // $this->load->view('front/navbar');

        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/staff-attendance/new_day'); 
        $this->load->view('erp/footer');

        // $this->load->view('front/footer-content');
        // $this->load->view('front/footer');
    }
    
    public function check_in(){
    // if($this->session->userdata('user')!=1){
        // redirect(base_url().'Welcome/attendence/');
    // }    

        $place=$_POST['place'];
        $note=$_POST['note'];
        $latd=$_POST['latd'];
        $lotd=$_POST['lotd'];
        $ip=$_POST['ip'];
        $table=$_POST['table'];
        $cat=date('Y-m-d-H-i-s');
        $date=date('Y-m-d');
        $time = date("H:i:s");
        $eid=$this->session->userdata('tid');
        // $session_id=$this->session->userdata('session_id');
        // $check_active_check_in=$this->UserModel->check_active_checkin
        $data_array=array("cat"=>$cat,"latd"=>$latd,"lotd"=>$lotd,"ip"=>$ip,"eid"=>$eid,"place"=>$place,"note"=>$note,"checkin_time"=>$time,"checkin_date"=>$date,"status"=>0);
    


        $check_active_checkin=$this->UserModel->check_active_checkin($eid,$date);
        if($check_active_checkin){
            // foreach($check_active_checkin as $check_in_data){
            // } 
        }else{
            $new_check_in=$this->UserModel->new_check_in($data_array,$table);
            if($new_check_in){
                echo $new_check_in;    
            }
        }
    }

    public function check_out(){
        // if($this->session->userdata('user')!=1){
        // redirect(base_url().'home/');
        // }    

        $eid=$this->session->userdata('tid');
        $check_out_session=$this->session->userdata('session_id');
        $date=date('Y-m-d');
        $time=date("H:i:s");
        $activity = $_POST['activity_id'];
        $latd=$_POST['latd'];
        $lotd=$_POST['lotd'];
        $ip=$_POST['ip'];
        $table=$_POST['table'];
        $cat =date('Y-m-d-H-i-s');
        $data_array=array("checkout_latd"=>$latd,"checkout_lotd"=>$lotd,"checkout_ip"=>$ip,"checkout_date"=>$date,"checkout_time"=>$time,"check_out_date_time"=>$cat,"status"=>1,"Checkout_session_id"=>$check_out_session);


        $checkout=$this->UserModel->checkout($activity,$eid,$date,$data_array,$table);
        if($checkout){
            // redirect(base_url().'home/dashboard');  
            echo $checkout;
        }else{
            redirect(base_url().'home/dashboard');      
        }   
    }
    
    public function mark_out_1(){
        // if($this->session->userdata('user')!=1){
        // redirect(base_url().'home/');
        // }    

        $eid=$this->session->userdata('tid');
        // $mark_out_session=$this->session->userdata('session_id');
        $date=date('Y-m-d');
        $time=date("H:i:s");
        $activity = $_POST['activity_id'];
        $latd=$_POST['latd'];
        $lotd=$_POST['lotd'];
        $ip=$_POST['ip'];
        $table=$_POST['table'];
        $cat =date('Y-m-d-H-i-s');
        $data_array=array(
            "markout_latd"=>$latd,
            "markout_lotd"=>$lotd,
            "markout_ip"=>$ip,
            "markOutDate"=>$date,
            "markOutTime"=>$time,
            "is_markout"=>1
        );


        $markout=$this->UserModel->markout($activity,$eid,$date,$data_array,$table);
        if($markout){
            // redirect(base_url().'home/dashboard');  
            echo $markout;
        }else{
            redirect(base_url().'home/dashboard');      
        }    
    }
    
    
    public function mark_out(){
        // if($this->session->userdata('user')!=1){
        //     redirect(base_url().'home/');
        // }    
        
        
        
        // $eid=$this->session->userdata('eid');
        $eid=$this->session->userdata('tid');
        $mark_out_session=$this->session->userdata('session_id');
        // $mark_out_session="";
        $date=date('Y-m-d');
        $time=date("H:i:s");
        $activity = $_POST['activity_id'];
        $latd=$_POST['latd'];
        $lotd=$_POST['lotd'];
        $ip=$_POST['ip'];
        $table=$_POST['table'];
        $cat =date('Y-m-d H:i:s');
        
        $check_active_checkin=$this->UserModel->check_active_checkin($eid,$date);
	    
	    if($check_active_checkin){
	        $total_seconds=0;
	        $table_checkout='activities';
	        $check_in_id='';
		    foreach($check_active_checkin as $checkin_data){
			    $d1=date('Y-m-d H:i:s',strtotime($checkin_data['cat']));
		        $check_in_id=$checkin_data['id'];
			    $start_date = new DateTime($d1);
			    $since_start = $start_date->diff(new DateTime($cat));
			    //echo $since_start->days;
			    //echo $since_start->y;
			    //echo $since_start->m;
			    $dayss= 24*60*60*$since_start->d;
			    $hourss=60*60*$since_start->h;
			    $minutess=60*$since_start->i;
			    $secondss= $since_start->s;	
			    $total_seconds=$dayss + $hourss + $minutess + $secondss;
		    }
		    $data_array=array("checkout_latd"=>$latd,"checkout_lotd"=>$lotd,"checkout_ip"=>$ip,"checkout_date"=>$date,"checkout_time"=>$time,"check_out_date_time"=>$cat,"status"=>1,"Checkout_session_id"=>$mark_out_session,"duration_in_seconds"=>$total_seconds);
            $checkout=$this->UserModel->checkout($check_in_id,$eid,$date,$data_array,$table_checkout);
	    }
        
        
	    $duration=0;
	    $daily_log=$this->UserModel->daily_log($date,$eid);
	    if($daily_log){
		    foreach($daily_log as $log_data){
			    $duration= $duration + $log_data['duration_in_seconds'];	
		    }
	    }
        $data_array=array("markout_latd"=>$latd,"markout_lotd"=>$lotd,"markout_ip"=>$ip,"markOutDate"=>$date,"markOutTime"=>$time,"is_markout"=>1,"markout_session_id"=>$mark_out_session,"work_time_duration"=>$duration,"mark_out_date_time"=>$cat);


        $markout=$this->UserModel->markout($activity,$eid,$date,$data_array,$table);
        if($markout){
            // redirect(base_url().'home/dashboard');  
            echo $markout;
        }else{
            redirect(base_url().'Welcome');      
        }
    }
    
    public function change_password(){
        $data['success']='';$data['error']='';
        if($this->session->userdata('user')!=1){
            redirect(base_url().'home');        
        }    
        $user_id = $this->session->userdata('tid');
        
        if(isset($_POST['change_password'])){
            $old_password=$this->input->post('old_password');
            $new_password=$this->input->post('new_password');
            $c_new_password=$this->input->post('c_new_password');
            $check_user=$this->UserModel->check_user_password($old_password,$user_id);
            if($check_user){
                if($new_password == $c_new_password){
                    $change_password=$this->UserModel->change_password($user_id,$new_password);    
                    if($change_password){
                        $data['success']="Your password changed successfully";
                    }else{$data['error']="Some error occured";}
                }    
    
            }else{
                $data['error']='Enter correct password';    
            }
        }
        $this->load->view('new-admin/header');
        $this->load->view('new-admin/front-sidebar');
        $this->load->view('front/change_password',$data);
        $this->load->view('new-admin/footer');

    }

    public function circular(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/circular'); 
        $this->load->view('erp/footer');
    }
    
    public function upload_signature(){
        $data['success']=""; $data['error']="";
        if(isset($_POST['upload_signature'])){
            $id=$_POST['id'];
        
            $profile_pic='';
	        $table='school_staff';
			
		    $config['file_ext_tolower'] =TRUE;
			$config['encrypt_name'] =TRUE;
			$config['upload_path']= './assets/signature/';
			$config['allowed_types']= 'jpeg|jpg|png';
			$config['max_size']= 5120;
			// $config['max_width']= 1024;
			// $config['max_height']= 768;
			$this->load->library('upload', $config);
			if ( ! $this->upload->do_upload('signature')){
			    $data['error']="Error in uploading image";
				// $data['error1'] = array('error' => $this->upload->display_errors());
			}else{
				$data1 = array('upload_data' => $this->upload->data());
				foreach($data1 as $img_data){
					$profile_pic=$img_data['file_name'];    
				}
			}
			
			$data_array_update=array("signature"=>$profile_pic);
			$update_staff_data=$this->WelcomeModel->update_item_data($data_array_update,$id,$table);
			if($update_staff_data){
			    $data['success']="Signature Uploaded Successfully";
			}else{
			    $data['error']="Error in uploading signature";
			}
        }
			
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/teachers/upload-signature',$data); 
        $this->load->view('erp/footer');
    }
    
    public function upload_principals_sign(){
        
    }

}