<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OpeningFee extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('DeveloperModel');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        $this->load->model('OpeningBalanceModel');
        $this->load->model('InvoiceModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    public function index(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('dev/courses');
        $this->load->view('erp/footer');
    }
    
    public function remove_other_data(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        $course_table='courses';
        $course_opening_count=0;
        $d_count=0;
        $all_courses=$this->DeveloperModel->get_data($course_table);
        if($all_courses){
            foreach($all_courses as $courses){
                $course=$courses['course'];
                $course_id=$courses['id'];
                                
                                
                $get_course_opening_data=$this->OpeningBalanceModel->get_course_opening_data($course);
                if($get_course_opening_data){
                    foreach($get_course_opening_data as $data){
                        if($data['opening_fee_amount'] == 0){
                            $item_id=$data['id'];
                            $item_table='opening_balance';
                                            
                            $course_opening_count=$course_opening_count + 1;
                            $opening_data_table='opening_balance_data';
                            $data_array=array(
                                "sid"=>$data['sid'],
                                "opening_fee_amount"=>$data['opening_fee_amount'],
                                "fee_note"=>$data['fee_note'],
                                "student_name"=>$data['student_name'],
                                "father_name"=>$data['father_name'],
                                "contact_no"=>$data['contact_no'],
                                "class"=>$data['class'],
                                "section"=>$data['section'],
                                "alt_contact_no"=>$data['alt_contact_no'],
                                "dob"=>$data['dob'],
                                "subject_stream"=>$data['subject_stream'],
                                "other"=>$data['other']
                            );
                            
                            $add_to_new_opening_data=$this->OpeningBalanceModel->insert_data($data_array,$opening_data_table);
                            if($add_to_new_opening_data){
                                $del_item=$this->DeveloperModel->delete_item_data($item_id,$item_table);
                                if($del_item){
                                    echo "Deleted Successfully <br>";
                                    $d_count=$d_count + 1;
                                }
                            }
                        }
                    }
                }
                                
            }
        }
                        
        echo $course_opening_count; echo "<br>";
        echo "Deleted Items - "; echo $d_count;
    }
    
    
    public function update_sid(){
        $get_course_students;
    }
    
    public function view_course_data($course){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('dev/course_data');
        $this->load->view('erp/footer');
    }
    
    public function course_students_opening_fee_info($course_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/welcome/view-course-students-opening-fee');
        $this->load->view('erp/footer');
    }
    
    public function course_opening_fee_pdf($course_id){
        
        $this->load->view('erp/welcome/pdf-view-course-opening-fee');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A4', 'portrait');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$course_id", array("Attachment"=>0));
    }
    
    public function invoice($fee_no){
        $this->load->view('erp/opening_fee/opening-fee-receipt');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$fee_no", array("Attachment"=>0));
    }
    
    public function all_invoices(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/opening_fee/all_invoices');
        $this->load->view('erp/footer');
    }
    
    public function delete_invoice(){
        $item_id=$_POST['item_id'];
        $opening_fee_table='opening_balance_fee';
        $get_invoice_data=$this->NewFeeModel->get_item_data($item_id,$opening_fee_table);
        // var_dump($get_invoice_data);
        $del_by=$this->session->userdata('tid');
        $del_at=date('Y-m-d H:i:s');
        
        if($get_invoice_data){
            foreach($get_invoice_data as $invoice_data){
                $invoice_array=array(
                    "inv_no"=>$invoice_data['id'],
                    "sid"=>$invoice_data['sid'],
                    "estimate_amount"=>$invoice_data['estimate_amount'],
                    "received_amount"=>$invoice_data['received_amount'],
                    "discount"=>$invoice_data['discount'],
                    "balance_amount"=>$invoice_data['balance_amount'],
                    "cat"=>$invoice_data['cat'],
                    "date"=>$invoice_data['date'],
                    "day"=>$invoice_data['day'],
                    "month"=>$invoice_data['month'],
                    "year"=>$invoice_data['year'],
                    "acedemic_session"=>$invoice_data['acedemic_session'],
                    "fee_for_ac_sess"=>$invoice_data['fee_for_ac_sess'],
                    "fee_date"=>$invoice_data['fee_date'],
                    "tid"=>$invoice_data['tid'],
                    "fee_note"=>$invoice_data['fee_note'],
                    "payment_mode"=>$invoice_data['payment_mode'],
                    
                    
		            "del_at"=>$del_at,
		            "del_by"=>$del_by
                );
                // var_dump( $invoice_array);
                $del_fee_table='opening_balance_fee_deleted';
                $fee_table='opening_balance_fee';
                $check_invoice_exist_in_deleted=$this->OpeningBalanceModel->get_del_invoice_info($item_id,$del_fee_table);
                if($check_invoice_exist_in_deleted){
                    
                }else{
                    $add_to_deleted=$this->OpeningBalanceModel->insert_data($invoice_array,$del_fee_table);
                    if($add_to_deleted){
                        
                        $delete_invoice_permanently=$this->OpeningBalanceModel->delete_opening_balance_fee_invoice_permanently($item_id,$opening_fee_table);
                        if($delete_invoice_permanently){
                            echo "Deleted Successfully";
                        }
                    }
                }
            }
        }
    }
    
    function undo_deleted_invoice(){
        $inv_no=$_POST['item_id'];
        $del_fee_table='opening_balance_fee_deleted';
        $opening_fee_table='opening_balance_fee';
        $get_deleted_invoice=$this->OpeningBalanceModel->get_del_invoice_info($inv_no,$del_fee_table);
        if($get_deleted_invoice){
            foreach($get_deleted_invoice as $invoice_data){
                $invoice_array=array(
                    "id"=>$invoice_data['inv_no'],
                    "sid"=>$invoice_data['sid'],
                    "estimate_amount"=>$invoice_data['estimate_amount'],
                    "received_amount"=>$invoice_data['received_amount'],
                    "discount"=>$invoice_data['discount'],
                    "balance_amount"=>$invoice_data['balance_amount'],
                    "cat"=>$invoice_data['cat'],
                    "date"=>$invoice_data['date'],
                    "day"=>$invoice_data['day'],
                    "month"=>$invoice_data['month'],
                    "year"=>$invoice_data['year'],
                    "acedemic_session"=>$invoice_data['acedemic_session'],
                    "fee_for_ac_sess"=>$invoice_data['fee_for_ac_sess'],
                    "fee_date"=>$invoice_data['fee_date'],
                    "tid"=>$invoice_data['tid'],
                    "fee_note"=>$invoice_data['fee_note'],
                    "payment_mode"=>$invoice_data['payment_mode']
                );
                
                $check_inv_exist=$this->OpeningBalanceModel->get_opening_fee_invoice_info($inv_no);
                if($check_inv_exist){
                    
                }else{
                    $add_to_deleted=$this->OpeningBalanceModel->insert_data($invoice_array,$opening_fee_table);
                    if($add_to_deleted){
                        
                        $delete_invoice_permanently=$this->OpeningBalanceModel->delete_opening_balance_deleted_fee_invoice_permanently($inv_no,$del_fee_table);
                        if($delete_invoice_permanently){
                            echo "Deleted Successfully";
                        }
                    }
                }
                
            }
        }
        
    }
    
    public function deleted_invoices(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/opening_fee/deleted-opening-fee-invoices');
        $this->load->view('erp/footer');
    }
    
}