<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Miscellaneous extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('MiscellaneousFeeModel');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    public function index(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/misc/dash1');
        // $this->load->view('erp/misc/dashboard');
        $this->load->view('erp/footer');
    }
    
    function fee_heads(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/misc/fee/all-fee-heads');
        $this->load->view('erp/footer');
    }
    
    function add_new_fee_head(){
        $data['success']='';
        $data['error']='';
        
        if(isset($_POST['add_misc_fee_head'])){
            $tid=$this->session->userdata('tid');
            $cat=date('Y-m-d H:i:s');
            $fee_head=$this->input->post('fee_head');
            $fee_amount_type=$this->input->post('fee_amount_type');
            
            $data_array=array("fee_head"=>$fee_head,"fee_amount_type"=>$fee_amount_type,"cat_by"=>$tid,"cat"=>$cat,"status"=>1);
            $table='misc_fee_heads';
            $check_fee_head_exist=$this->MiscellaneousFeeModel->check_fee_head_exist($fee_head,$fee_amount_type,$table);
            if($check_fee_head_exist){
                $data['error']="Fee Head Already Exist";
            }else{
                $add_fee_head=$this->MiscellaneousFeeModel->insert_data($data_array,$table);
                if($add_fee_head){
                    $data['success']='Fee Head Added Successfully';
                }else{
                    $data['error']='Error in adding fee head';
                }
            }

        }
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/misc/fee/add-fee-head',$data);
        $this->load->view('erp/footer');
    }
    
    function fee_structure(){
        
    }
    
    function update_fee_structure(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/misc/fee/update-fee-structure');
        $this->load->view('erp/footer');
    }
    
    
    
}