<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('FrontModel');
        $this->load->model('CalenderModel');
        $this->load->model('StudentAccessModel');
        $this->load->model('InvoiceModel');
        $this->load->model('NewFeeModel');
        $this->load->helper('date');
        $this->load->database();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->library('Pdf');
    }
    
    public function index(){
        $this->load->view('erp/student-portal/header');
        $this->load->view('erp/student-portal/navbar');
        $this->load->view('erp/student-portal/welcome');
        $this->load->view('erp/student-portal/footer');
    }
    
    public function profile(){
        $this->load->view('erp/student-portal/header');
        $this->load->view('erp/student-portal/navbar');
        $this->load->view('erp/student-portal/profile');
        $this->load->view('erp/student-portal/footer');
    }
    
    public function attendance(){
        $this->load->view('erp/student-portal/header');
        $this->load->view('erp/student-portal/navbar');
        $this->load->view('erp/student-portal/my-attendance');
        $this->load->view('erp/student-portal/footer');
    }
    
    
    public function draw_calender(){

        $month =$_POST['month'];
        $year =$_POST['year'];
        $d=1;
        $month_name = date("F", mktime(0, 0, 0, $month, 10));	
        $calendar='';
        $calendar .='<div class="table-responsive">';
        $calendar.="".$month_name."-".$year."";  
	    $calendar .= '<table  class="table table-bordered calendar">';

    	/* table headings */
        $headings = array('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
        $calendar.= '<tr class="calendar-row"><td class="calendar-day-head">'.implode('</td><td class="calendar-day-head">',$headings).'</td></tr>';

	    /* days and weeks vars now ... */
        $running_day = date('w',mktime(0,0,0,$month,1,$year));
        $days_in_month = date('t',mktime(0,0,0,$month,1,$year));
        $days_in_this_week = 1;
        $day_counter = 0;
        $dates_array = array();

    	/* row for week one */
        $calendar.= '<tr class="calendar-row">';

    	/* print "blank" days until the first of the current week */
	    for($x = 0; $x < $running_day; $x++):
		    $calendar.= '<td class="calendar-day-np"> </td>';
		    $days_in_this_week++;
	   endfor;

	    /* keep going with days.... */
	    for($list_day = 1; $list_day <= $days_in_month; $list_day++):
		    $calendar.= '<td class="calendar-day">';
            // <a href="'.base_url().'Management/attendance_log/'.$list_day.'/'.$month.'/'.$year.'">		
            /* add in the day number */
			
    			$check_holiday=$this->CalenderModel->check_holiday_date($list_day,$month,$year);
			if($check_holiday){
			    foreach($check_holiday as $holiday){
    			    $calendar .='<div class="event  text-danger text-center  font-weight-bold width:70%;">'.$holiday['holiday_detail'].'</div>';
			    }
			}
            $sid=$this->session->userdata('sid');			    
            $student_attendance=$this->StudentAccessModel->student_attendance($sid,$list_day,$month,$year);			    
            if($student_attendance){
                foreach($student_attendance as $attendance){
                    if($attendance['status'] =='p'){
                        $calendar .='<div class="atd font-weight-bold width:30%;">P</div>';
                    }else if($attendance['status'] =='a'){
                        $calendar .='<div class="atd1 font-weight-bold width:30%;">A</div>';
                    }    
                }
            }			    
			$calendar.= '<div class="day-number">'.$list_day.'</div>';

			/** QUERY THE DATABASE FOR AN ENTRY FOR THIS DAY !!  IF MATCHES FOUND, PRINT THEM !! **/
			$calendar.= str_repeat('<p> </p>',2);
            // 			</a>
		    $calendar.= '</td>';
		    if($running_day == 6):
			    $calendar.= '</tr>';
			    if(($day_counter+1) != $days_in_month):
				    $calendar.= '<tr class="calendar-row">';
			    endif;
			    $running_day = -1;
			    $days_in_this_week = 0;
		    endif;
		    $days_in_this_week++; $running_day++; $day_counter++;
	   endfor;

	    /* finish the rest of the days in the week */
	    if($days_in_this_week < 8):
		    for($x = 1; $x <= (8 - $days_in_this_week); $x++):
			    $calendar.= '<td class="calendar-day-np"> </td>';
		    endfor;
	    endif;

	    /* final row */
	    $calendar.= '</tr>';

	    /* end the table */
	    $calendar.= '</table></div>';
	
	    $calendar .='<div class="table-responsive">
	        <table class="table table-bordered table-striped"><tbody>';
        $check_holiday=$this->CalenderModel->get_holidays_in_month($month,$year);
        if($check_holiday){
	        foreach($check_holiday as $holiday){
	            $calendar .='<tr>
	                <th>'.date('d-M-Y',strtotime($holiday['holiday_date'])).'</th>
	                <td>'.$holiday['holiday_detail'].'</td>
	                </tr>';
	        }
        }
	    $calendar .='</tbody>
	    </table
	    <div>';
	    /* all done, return result */
	    echo $calendar;    
    }    
    
    
    
    public function my_teachers(){
        $this->load->view('erp/student-portal/header');
        $this->load->view('erp/student-portal/navbar');
        $this->load->view('erp/student-portal/my-teachers');
        $this->load->view('erp/student-portal/footer');
    }

    public function fee_paid_detail(){
        $this->load->view('erp/student-portal/header');
        $this->load->view('erp/student-portal/navbar');
        $this->load->view('erp/student-portal/my-fee-invoices');
        $this->load->view('erp/student-portal/footer');    
    }



    // public function feeInvoice($feeno){
    //     $old_limit=ini_set("memory_limit", "16M");
    //     $dompdf=new Pdf();
    //     $dompdf->set_paper('letter','portrait'); //landscape , portrait
    //     $html_content='';
    //     $html_content.=$this->FeeModel->fetch_single_fee_details($feeno);
    //     $this->pdf->loadHtml($html_content);
    //     $this->pdf->render();
    //     $this->pdf->stream("".$feeno.".pdf", array("Attachment"=>0));
    // }
    
    public function feeInvoice($fee_no){
        $this->load->view('erp/new-fee/fee-receipt-pdf');
        // Get output html
        $html = $this->output->get_output();
        // Load HTML content
        $this->pdf->loadHtml($html);
    
        $old_limit = ini_set("memory_limit", "512M");
        // (Optional) Setup the paper size and orientation
        $this->pdf->setPaper('A5', 'landscape');
        // Render the HTML as PDF
        $this->pdf->render();
   
        // Output the generated PDF (1 = download and 0 = preview)
        $this->pdf->stream("$fee_no", array("Attachment"=>0));
    }

    public function fee_dues(){
        $this->load->view('erp/student-portal/header');
        $this->load->view('erp/student-portal/navbar');
        $this->load->view('erp/student-portal/my-fee-dues');
        $this->load->view('erp/student-portal/footer');     
    }
    
}