<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Developer extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->helper('text');
        $this->load->helper(array('form','url'));
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('DeveloperModel');
        $this->load->model('NewFeeModel');
        $this->load->model('WelcomeModel');
        $this->load->model('NewExamModel');
        $this->load->model('EnquiryModel');
        $this->load->model('ExamManagementModel');
        $this->load->helper('date');
        $this->load->database();    
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->library('Pdf');
    }

    public function index(){
        // echo "All items";
        // $userid="SJEC-1";
        //     echo $sid=substr($userid,5);
        if(isset($_POST['scan_barcode'])){
            $userid=$_POST['userid'];
            $sid=substr($userid,5);
            if($userid !=''){
                redirect(base_url().'Fee/pay/'.$sid);    
                // redirect(base_url().'Home/');  
            }
            
        }
        $this->load->view('erp/dev/barcode.php');
        // $this->load->view('erp/footer');
    }


    public function active_session(){
        echo $acedemic_session=$this->session->userdata('acedemic_session');
    }

    public function task1(){
    // Add student course for session 2020-2021
    // echo $this->session->userdata('');
        $section1='A';
        $acedemic_session_table='academic_session_details';
        $acedemic_session=$this->session->userdata('acedemic_session');
        $acedemic_session_data=$this->NewFeeModel->get_item_data($acedemic_session,$acedemic_session_table);
        if($acedemic_session_data){
            foreach($acedemic_session_data as $session_data){
                echo $ac_year=$session_data['year_long']; echo "<br>";
                $table='student';
                $count=0;
                $course_count=0;
                $all_students=$this->DeveloperModel->get_active_data($table);
                if($all_students){
                    foreach($all_students as $students){
                        if($students['status'] !=2 ){
                            
                        // }else{
                        $count = $count + 1;    
                        $sid=$students['id'];
                        $course_id=$students['course_id'];
                        $data_array=array("sid"=>$students['id'],"acedemic_session"=>$acedemic_session,"class"=>$students['class'],"section"=>$section1,"ac_year"=>$ac_year,"course_id"=>$course_id);
                        // print_r($data_array);echo "<br>";
                        $check_student=$this->DeveloperModel->check_student_session($sid,$acedemic_session);
                        if($check_student){
                            echo "Already Added";
                        }else{
                            $course_table='student_courses_data';
                            $add_student_course=$this->DeveloperModel->insert_data($data_array,$course_table);
                            if($add_student_course){
                                $course_count=$course_count + 1;    
                            }
                        }
                    }
                    //
                    }
                }

                echo $count;
                echo "course_count"; echo "-"; echo $course_count;
            }
        }
    }


    public function task2(){
        $ac_session_id=1;
        // $table='school_classes_structure';
        $table='fee_structure';
        $data_array=array("acedemic_session"=>$ac_session_id);
        $update_data=$this->DeveloperModel->update_all($table);
        if($update_data){
            echo $update_data;
        }
    }


    public function task3(){
        $ac_session_id=1;
        // $table='school_classes_structure';
        $table='attendence';
        $data_array=array("closed"=>1);
        $update_data=$this->DeveloperModel->close_attendance($table);
        if($update_data){
            echo $update_data;
        }
    }



    public function convert_admission($id){
        $eq_table='enquiry';
        $student_table='student';
        $acedemic_session=2;
        $ac_year='2021-2022';
        $student_courses_table='student_courses_data';
        $get_student_data=$this->DeveloperModel->get_item_data($id,$eq_table);
        if($get_student_data){
            foreach($get_student_data as $student_data){
                $cat=date('Y-m-d H:i:s');
                $mobile_number=$student_data['mobile_number'];
                $student_name="".$student_data['first_name']." ".$student_data['last_name'];
                echo $student_name;

                $check_enquiry_student_exist=$this->DeveloperModel->check_enquiry_student_exist($id,$student_table);
                if($check_enquiry_student_exist){
                    echo "Error Already Added";
                }else{
                    $student_array=array("sch_no"=>$student_data['enquiry_no'],"enquiry_id"=>$student_data['id'],"student_name"=>$student_name,"father_name"=>$student_data['father_name'],"dob"=>$student_data['dob'],"class"=>$student_data['class'],"section"=>$student_data['section'],"contact_no"=>$student_data['mobile_number'],"password"=>$student_data['mobile_number'],"email"=>$student_data['email'],"admission_class"=>$student_data['class'],"status"=>1);
                    $add_to_student=$this->DeveloperModel->insert_data($student_array,$student_table);
                    if($add_to_student){
                        $data_array=array("sid"=>$add_to_student,"acedemic_session"=>$acedemic_session,"class"=>$student_data['class'],"section"=>$student_data['section'],"ac_year"=>$ac_year,"cat"=>$cat);
                        $add_to_student_courses_data=$this->DeveloperModel->insert_data($data_array,$student_courses_table);
                        if($add_to_student_courses_data){
                            echo "Added to course data";
                            $login_data_array=array("sch_no"=>$student_data['enquiry_no'],"user_id"=>$add_to_student,"username"=>$student_data['enquiry_no'],"Name"=>$student_name,"mob_number"=>$mobile_number,"usertype"=>'student',"status"=>1,"password"=>md5($mobile_number),"cat"=>$cat);
                            $cred_table='login_credentials';
                            $add_login_credentials=$this->DeveloperModel->insert_data($login_data_array,$cred_table);
                            if($add_login_credentials){
                                echo " Login Cred Added successfully";
                            }
                        }

                    }
                }


            }
        }
    }
    public function convert_to_admission(){
        $this->load->view('erp/enquiry/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/enquiry/convert-to-admission');
        $this->load->view('erp/footer');
    }

    public function promote_course_all_students($course){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/promote-course-students');
        $this->load->view('erp/footer');
    }
    
    public function course_students_pdf($course,$acedemic_session){
        $old_limit = ini_set("memory_limit", "1024M");
        $dompdf = new Pdf();
        $dompdf->set_paper('letter', 'portrait'); //landscape , portrait
        $html_content = '';
        $html_content .= $this->DeveloperModel->course_students_pdf($course,$acedemic_session);
        $this->pdf->loadHtml($html_content);
        $this->pdf->render();
        $this->pdf->stream("".$course.".pdf", array("Attachment"=>0));
    }
    
    // public function delete_from_student_courses_data(){
    //         $delete_from_student_courses_data=$this->DeveloperModel->delete_from_student_courses_data();
    //         if($delete_from_student_courses_data){
    //             echo $delete_from_student_courses_data;
    //         }
    // }
    
    public function get_student_info(){
        $sid=1642;
        // $acedemic_session=$this->session->userdata('acedemic_session');
        $acedemic_session=2;
        $get_student_info=$this->DeveloperModel->check_student_session($sid,$acedemic_session);
        if($get_student_info){
            foreach($get_student_info as $info){
                echo $info['id'];
                echo "<br>";
                echo $info['class'];
                echo "<br>";
                echo $info['section'];
                echo "<br>";
                echo $info['course_id'];
            }
        }
    }
    
    public function contact_detail(){
        
    }
    
    public function get_course_students_ac_session(){
        // $course=3;
        $acedemic_session=2;
        $get_course_students=$this->DeveloperModel->get_course_students($course,$acedemic_session);
        $count=0;
        $deleted=0;
        if($get_course_students){
            foreach($get_course_students as $students){
                $count=$count + 1;        
                $sid=$students['sid'];
                $table='student';
                $deleted_table='students_deleted';
                $get_item_info=$this->NewFeeModel->get_item_data($sid,$table);
                $cat=date('Y-m-d H:i:s');
                $cat_by=$this->session->userdata('tid');
                if($get_item_info){
                    foreach($get_item_info as $info){
                        $data_array=array("sid"=>$info['id'],"student_name"=>$info['student_name'],"father_name"=>$info['father_name'],"mother_name"=>$info['mother_name'],"dob"=>$info['dob'],"class"=>$info['class'],"contact_no"=>$info['contact_no'],"sr_no"=>$info['sr_no'],"adm_no"=>$info['adm_no'],"gender"=>$info['gender'],"admission_date"=>$info['admission_date'],"religion"=>$info['religion'],"caste"=>$info['caste'],"password"=>$info['password'],"status_description"=>$info['status_description'],"status"=>$info['status'],"cat"=>$cat,"cat_by"=>$cat_by);
                        $add_to_deleted=$this->NewFeeModel->insert_data($data_array,$deleted_table);
                        if($add_to_deleted){
                            $delete_item=$this->NewFeeModel->delete_item($sid,$table);                        
                            if($delete_item){
                                echo "Deleted Successfully";
                                $deleted =$deleted + 1;
                            }
                        }

                    }
                }
            }
        }
        echo $count;
        echo "<br>";
        echo $deleted;
    }
    
    public function get_undefined_students(){
        // $course='';
        $table='student';
        $count=0;
        
        $deleted_table='students_deleted';
        
        $cat=date('Y-m-d H:i:s');
        $cat_by=$this->session->userdata('tid');
        
        $get_undefined_students=$this->DeveloperModel->get_undefined_students($course,$table);
        if($get_undefined_students){
            foreach($get_undefined_students as $info){
                $count=$count + 1;
                // echo $count;
                // echo "-"; echo $students['student_name'] ;echo "<br>";
                $sid=$info['id'];
                $data_array=array("sid"=>$info['id'],"student_name"=>$info['student_name'],"father_name"=>$info['father_name'],"mother_name"=>$info['mother_name'],"dob"=>$info['dob'],"class"=>$info['class'],"contact_no"=>$info['contact_no'],"sr_no"=>$info['sr_no'],"adm_no"=>$info['adm_no'],"gender"=>$info['gender'],"admission_date"=>$info['admission_date'],"religion"=>$info['religion'],"caste"=>$info['caste'],"password"=>$info['password'],"status_description"=>$info['status_description'],"status"=>$info['status'],"cat"=>$cat,"cat_by"=>$cat_by);
                $add_to_deleted=$this->NewFeeModel->insert_data($data_array,$deleted_table);
                if($add_to_deleted){
                    $delete_item=$this->NewFeeModel->delete_item($sid,$table);
                    if($delete_item){
                        echo $count; echo "-"; echo "Deleted Successfully<br>";
                        
                    }
                }
                
                
            }
        }
    }
    
    public function add_imported_students(){
        $table='student_new_imported';
        $get_table_data=$this->DeveloperModel->get_data($table);
        $count=0;
        $cat=date('Y-m-d H:i:s');
        $cat_by=$this->session->userdata('tid');
        if($get_table_data){
            foreach($get_table_data as $info){
                $student_table='student';
                $data_array=array("impor_ref_id"=>$info['id'],"student_name"=>$info['student_name'],"father_name"=>$info['father_name'],"mother_name"=>$info['mother_name'],"dob"=>$info['dob'],"class"=>$info['class'],"contact_no"=>$info['contact_no'],"sr_no"=>$info['sr_no'],"adm_no"=>$info['adm_no'],"gender"=>$info['gender'],"admission_date"=>$info['admission_date'],"religion"=>$info['religion'],"caste"=>$info['caste'],"address"=>$info['address'],"status_description"=>$info['status_description'],"status"=>$info['status'],"cat"=>$cat,"cat_by"=>$cat_by,"alternate_no"=>$info['alternate_no']);
                $ref_id=$info['id'];
                $check_student=$this->DeveloperModel->check_student_imp_refrence($ref_id);
                if($check_student){
                    echo "Already Added<br>";
                }else{
                    $add_to_student=$this->NewFeeModel->insert_data($data_array,$student_table);
                    if($add_to_student){
                        $count=$count + 1;
                        echo "Added Successfully<br>";
                    }
                }
            }
        }   
        echo "Total Added : ";
        echo $count;
    }
    
    public function sess_data(){
        $cat_by=$this->session->userdata('tid');
        echo $cat_by;
    }
    
    public function all_courses(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/all_courses');
        $this->load->view('erp/footer');
    }
    
    
    public function update_course_id($course_id){
        $table='courses';
        $student_table='student';
        $student_courses_table='student_courses_data';
        $course_update_count=0;
        $get_course_info=$this->DeveloperModel->get_item_data($course_id,$table);
        $update_count=0;
        if($get_course_info){
            foreach($get_course_info as $info){
                $course=$info['course'];
                $update_course_id=$this->DeveloperModel->update_course_id($course,$course_id,$student_table);
                if($update_course_id){
                    echo $update_course_id;
                    echo "<br>";
                    $update_count=$update_count + 1;
                    $update_course_id_in_courses_data_table=$this->DeveloperModel->update_course_id($course,$course_id,$student_courses_table);
                    if($update_course_id_in_courses_data_table){
                        $course_update_count=$course_update_count + 1;
                        echo $update_course_id_in_courses_data_table;
                        echo "<br>";
                    }
                    
                }
            }
        }
        
        echo $update_count;
        echo "<br>";
        echo $course_update_count;
    }
    
    public function all_courses_old(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/all_courses_old');
        $this->load->view('erp/footer');
    }
    
    public function old_course_students($courses_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/view_old_students_for_course');
        $this->load->view('erp/footer');
    }
    
    public function view_new_admission($courses_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/view-new-students');
        $this->load->view('erp/footer');
    }
    
    public function view_deleted_course_students($course){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/deleted_students_for_course');
        $this->load->view('erp/footer');
    }
    
    public function update_course_id_for_higher_class(){
        $course=12;
        $course_id=19;
        $student_table='student';
        $student_courses_table='student_courses_data';
        $update_course_id=$this->DeveloperModel->update_course_id_for_class($course,$course_id,$student_table);
        if($update_course_id){echo "Students Updated 1:"; echo $update_course_id; echo "<br>";}
        
        $update_in_courses_data=$this->DeveloperModel->update_course_id_for_class($course,$course_id,$student_courses_table);
        if($update_in_courses_data){echo "Students Updated 2:"; echo $update_in_courses_data;}
        
    }
    
    public function promote_old_students_manually(){
        $course='LKG';
        // $course_id='';
        
        $new_course='UKG';
        $new_course_id=3;
        
        $table='student';
        $count=0;
        $passout_count=0;
        $promote_count=0;
        $get_old_students=$this->DeveloperModel->get_course_old_students($course,$table);
        if($get_old_students){
            foreach($get_old_students as $students){
                $count=$count + 1;    
                $sid=$students['id'];
                // $passout_student=$this->DeveloperModel->make_student_passout($sid);
                // if($passout_student){
                //     $passout_count=$passout_count + 1;
                // }
                
                $data_array_update=array("class"=>$new_course,"course_id"=>$new_course_id);
                
                $promote_student=$this->DeveloperModel->get_student_promoted($sid,$data_array_update);
                if($promote_student){
                    $promote_count=$promote_count + 1;
                }
                
                
                
                
                
                
            }
        }
        echo $count;echo "<br>";
        echo $promote_count;
    }
    
    public function update_status(){
        echo $update_all_students=$this->DeveloperModel->update_student_status();
    }
    
    public function delete_opening_item_data(){
        $table='opening_balance';
        $id=1775;
        $count=0;
        $del_count=0;
        for($i;$id<=1847;$id++){
            $get_item_data=$this->DeveloperModel->get_item_data($id,$table);
            if($get_item_data){
                foreach($get_item_data as $data){
                    $count=$count + 1;
                    echo $count; echo "/";echo $data['id']; echo "-";echo $data['student_name']; echo "-"; echo $data['opening_fee_amount'];
                    $delete_item_data=$this->DeveloperModel->delete_item_data($id,$table);
                    if($delete_item_data){
                        echo "/<span style='color:red;'>Deleted Successfully</span>/";
                        $del_count=$del_count + 1;
                    }
                    echo "<br>"; 
                }
            }
        }
        
        echo $del_count;
        
        
    }
    
    
    
    public function remove_extra_students(){
        $table="student";
        $id=2218;
        $count=0;
        $del_count=0;
        for($i;$id<=2367;$id++){
            $get_item_data=$this->DeveloperModel->get_item_data($id,$table);
            if($get_item_data){
                foreach($get_item_data as $data){
                    $count=$count + 1;
                    echo $count; echo "/";echo $data['id']; echo "-";echo $data['student_name']; echo "-"; 
                    // echo $data['opening_fee_amount'];
                    $delete_item_data=$this->DeveloperModel->delete_item_data($id,$table);
                    if($delete_item_data){
                        echo "/<span style='color:red;'>Deleted Successfully</span>/";
                        $del_count=$del_count + 1;
                    }
                    echo "<br>"; 
                }
            }
        }
        
        echo $del_count;
    }
    
    public function update_student_courses_data(){
        $student_courses_data_table='student_courses_data';
        $get_all_courses_data=$this->WelcomeModel->get_data($student_courses_data_table);
        $count=0;
        if($get_all_courses_data){
            foreach($get_all_courses_data as $data){
                $sid=$data['sid'];
                $data_array_update=array("status"=>1);
                $update_item_data=$this->WelcomeModel->update_status_in_student_courses_data($sid,$data_array_update);
                if($update_item_data){
                    $count=$count + 1;
                }
            }
        }
        
        echo $count; echo "-";echo "Record Updated Successfully";
        
    }
    
    public function hscourses(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/higher-secondary-courses');
        $this->load->view('erp/footer');   
    }
    
    public function get_course_fee_data($course_id){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/new-fee/hs-fee-data');
        $this->load->view('erp/footer');
    }
    
    public function update_students_course_id_fee_table(){
        $fee_table='student_fee';
        $count=0;
        $get_all_fee_data=$this->NewFeeModel->get_data($fee_table);
        if($get_all_fee_data){
            foreach($get_all_fee_data as $fee_data){
                $sid=$fee_data['sid'];
                $fee_no=$fee_data['fee_no'];
                $acedemic_session=$fee_data['acedemic_session'];
                // $course_id='';
                // $get_active_course_data=$this->NewFeeModel->get_studdents_current_course_data($sid,$acedemic_session);
                // if($get_active_course_data){
                //     foreach($get_active_course_data as $active_course_data){
                //         $course_id=$active_course_data['course_id'];
                //     }
                // }
                if($fee_data['payment_mode'] =='check'){
                    $data_array_update=array("payment_mode"=>"cheque");    
                    $update_fee_courses_data=$this->NewFeeModel->update_fee_data($fee_no,$data_array_update);
                    if($update_fee_courses_data){
                        $count=$count + 1;
                    }
                }
                
                

                
            }
        }
        echo $count;
        
    }
    
    public function opening_fee_data(){
        $fee_for_ac_sess=1;
        // $table='opening_balance';
        $table='opening_balance_fee';
        $update_opening_fee_for_ac_sess=$this->DeveloperModel->update_opening_fee_for_ac_sess($fee_for_ac_sess,$table);
        if($update_opening_fee_for_ac_sess){
            echo $update_opening_fee_for_ac_sess;
        }
        
    }
    
    public function bal_data_calibration(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/bal-fee_status');
        $this->load->view('erp/footer');
    }
    
    public function inv_bal_calibration(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/inv-bal-fee-status-calibration');
        $this->load->view('erp/footer');
    }
    
    public function extra_fee_data_calibration(){
        
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/extra-fee-amount-status');
        $this->load->view('erp/footer');
    }
    
    public function inv_extra_calibration(){
        $this->load->view('erp/header');
        $this->load->view('erp/sidebar');
        $this->load->view('erp/dev/inv-extra-fee-status-calibration');
        $this->load->view('erp/footer');
    }
    
    
    public function update_student_course_data(){
        $count=0;
        $table="student";
        $all_students=$this->WelcomeModel->get_data($table);
        if($all_students){
            foreach($all_students as $students_data){
                $sid=$students_data['id'];
                $data_array_update=array("student_name"=>$students_data['student_name'],"contact_no"=>$students_data['contact_no'],"father_name"=>$students_data['father_name']);
                $update_student_course_data=$this->WelcomeModel->update_status_in_student_courses_data($sid,$data_array_update);
                if($update_student_course_data){
                    $count = $count + 1;
                }
            }
        }
        
        echo $count; 
    }
    
    
    public function ttt1(){
        $acedemic_session=3;
        $result_table="exam_result";
        $all_students=$this->DeveloperModel->get_session_students_result($acedemic_session,$result_table);
        if($all_students){
            foreach($all_students as $data){
                $sid=$data['sid'];
                $roll_no=$data['roll_no'];
                $course_id=$data['course_id'];
                
                $student_course_data_array=array("roll_no"=>$roll_no);
                $student_course_data_table="student_courses_data";
        
                // $update_student_course_data=$this->NewExamModel->update_student_course_data_1($sid,$acedemic_session,$course_id,$student_course_data_array,$student_course_data_table);
                // if($update_student_course_data){
                //     echo $sid."-".$roll_no."-Updated<br>";
                // }
            }
        }
    }
    
    
    public function new_admissions(){
        $acedemic_session=$this->session->userdata('acedemic_session');
        echo "Acedemic Session : ".$acedemic_session;
        echo "<br>";
        $table = 'enquiry';
        $all_enq=$this->EnquiryModel->get_current_enquiry($acedemic_session,$table); 
        $count=0;
        $cat=date("Y-m-d H:i:s");
        $tid=$this->session->userdata("tid");
        echo "<br>";
        $student_table='student';
        if($all_enq){
            foreach($all_enq as $enq){
                $enquiry_id=$enq['id'];
                $count=$count + 1;
                echo $count.":".$enq['id']."-Name: ".$enq['first_name'].", Admission-Status:".$enq['admission_status']."<br>";
                $get_student_data=$this->DeveloperModel->check_enquiry_student_exist($enquiry_id,$student_table);
                if($get_student_data){
                    foreach($get_student_data as $student){
                        $sid=$student['id'];
                        echo "SID : ".$sid;
                        
                        echo "<br>";
                        
                        $get_course_data=$this->DeveloperModel->check_student_session($sid,$acedemic_session);
                        if($get_course_data){
                            foreach($get_course_data as $course_data){
                                echo "Hi : ";
                                echo $course_data['id']."-";
                                  
                                echo $date_of_admission=date("Y-m-d",strtotime($course_data['cat']));
                                echo "<br>";  
                                $data_array_update=array(
                                    "new_admission"=>"Yes",
                                    "date_of_admission"=>$date_of_admission,
                                    "uat"=>$cat,
                                    "upd_by"=>$tid
                                );
                                $item_id=$course_data['id'];
                                $student_courses_table='student_courses_data';
                                $update_item_data=$this->DeveloperModel->update_item_data($item_id,$data_array_update,$student_courses_table);
                                if($update_item_data){
                                    echo "Updated";
                                    echo "<br>";  
                                }
                            }
                            
                        }
                    }
                }else{}
            }
        }
    }
    
    public function emergency_task(){
        $acedemic_session=4;
        $all_students=$this->DeveloperModel->get_student_course_data($acedemic_session);
        if($all_students){
            foreach($all_students as $students){
                $student_id=$students['sid'];
                $id=$students['id'];
                $class=$students['class'];
                $section=$students['section'];
                $acedemic_session_1=3;
                
                if($section ==""){
                    $get_old_sess_data=$this->DeveloperModel->get_student_course_data_a($student_id,$acedemic_session_1,$sid);
                    $section_1="";
                    if($get_old_sess_data){
                        foreach($get_old_sess_data as $sess_data_1){
                            $section_1=$sess_data_1['section'];
                        }
                    }
                    echo $student_id."-".$class."-".$section."<br>";
                    echo $section_1."<br>";
                    $table="student_courses_data";
                    $data_array_update=array("section"=>$section_1);
                    // $update_section_data=$this->DeveloperModel->update_item_data($id,$data_array_update,$table);
                }
                
                
            }
        }
    }
    
    public function exam_subject_automation(){
        $class="";
        $section="";
        $academic_session=$this->session->userdata("acedemic_session");
        $all_class_and_sections=$this->ExamManagementModel->get_class_section_structure($academic_session);
        if($all_class_and_sections){
            foreach($all_class_and_sections as $data){
                $class=$data["class"];
                $section=$data["section"];
            }
        }
    }
    
    
    
    public function allot_subjects(){
        $data['success']=""; $data['error']="";
         $acedemic_session=$this->session->userdata('acedemic_session');
        $courses_table="courses";
        $scd_table="student_courses_data";
        $all_courses=$this->DeveloperModel->get_data($courses_table);
        if($all_courses){
            foreach($all_courses as $courses){
                $class=$courses['course'];
                $all_class_students=$this->DeveloperModel->get_class_students($class,$acedemic_session,$scd_table);
                $exam_subjects_table='exam_subject_master_'.$acedemic_session;
                        $course_subject_list=$this->ExamManagementModel->get_class_active_subjects($class,$exam_subjects_table);
                if($all_class_students){
                    foreach($all_class_students as $students){
                        $sid=$students['sid'];
                        $cehck_student_exists=$this->DeveloperModel->check_student_subjects_exists($sid);
                        if($cehck_student_exists){
                            
                        }else{
                            
                        // }
                        
                        
                        $course_id=$students['course_id'];
                        // $class=$students['class'];
                        $section=$students['section'];
                        $cat=date('Y-m-d H:i:s');
                        $tid=$this->session->userdata('tid');
                        $added_subject_count=0;
                        
                        if($course_subject_list){
                            foreach($course_subject_list as $subjects){
                                $subjectid=$subjects['id'];
                                $student_subjects_table="student_subjects_".$acedemic_session;
                                $data_array=array("sid"=>$sid,"course_id"=>$course_id,"class"=>$class,"section"=>$section,"academic_session"=>$acedemic_session,"subject_id"=>$subjectid,"status"=>1,"created_by"=>$tid,"created_at"=>$cat,"updated_at"=>$cat,"updated_by"=>$tid);
                        
                                // $check_student_subject_exist=$this->ExamManagementModel->student_subject_info($sid,$acedemic_session,$subject_id,$student_subjects_table);
                                // if($check_student_subject_exist){
                                //     // echo "Subject already added for student.";
                                // }else{
                                    $add_subject=$this->ExamManagementModel->insert_data($data_array,$student_subjects_table);
                                    if($add_subject){
                                        // echo "Subject added successfully.";
                                        $added_subject_count=$added_subject_count + 1;
                                
                                    }else{
                                        // echo "Error in adding subject.";
                                    }
                                // }
                            }
                        }
                    // Class Students Close  
                    
                    echo $class."-".$section."-".$sid.":".$added_subject_count."<br>";
                    }
                    
                    }
                }else{
                    echo "NAA";
                }
                
            // All Courses Close    
            }
        }else{
            echo "NA";
        }
    }
    
}