<?php
class TimeTableModel extends CI_Model {
    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;  
    }
    
    public function insert_data($table,$data_array){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();	    
    }
    
    public function get_schedule_periods($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('time_table_id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function all_classes(){
        $sql="SELECT DISTINCT course FROM courses";
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    
    public function get_all_teaching_staff($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('user_status',1);
        $this->db->where('status',0);
        $this->db->where('staff_category','teaching-staff');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_time_table_record($time_table_id,$period,$tid,$week_day){
        $table="time_table_record";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('time_table_id',$time_table_id);
        $this->db->where('period_id',$period);
        $this->db->where('tid',$tid);
        $this->db->where('week_day',$week_day);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_class_section_record($time_table_id,$class,$section,$period,$week_day){
        $table="time_table_record";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('time_table_id',$time_table_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('period_id',$period);
        $this->db->where('week_day',$week_day);
        // $this->db->where('tid',$tid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_class_section_record($id,$class,$section,$period){
        $sql="SELECT schedule.*,school_staff.salutation,name FROM time_table_record as schedule LEFT JOIN school_staff ON schedule.tid=school_staff.id WHERE schedule.time_table_id='$id' AND schedule.class='$class' AND schedule.section='$section' AND schedule.period_id='$period'";
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    public function get_class_section_day_record($id,$class,$section,$period,$day){
        $sql="SELECT schedule.*,school_staff.salutation,name FROM time_table_record as schedule LEFT JOIN school_staff ON schedule.tid=school_staff.id WHERE schedule.time_table_id='$id' AND schedule.class='$class' AND schedule.section='$section' AND schedule.period_id='$period' AND schedule.week_day='$day'";
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    public function update_class_section_record($time_table_id,$class,$section,$period,$week_day,$data_array_update,$table){
        $this->db->where('time_table_id',$time_table_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('period_id',$period);
        $this->db->where('week_day',$week_day);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_classes_structre($acedemic_session){
        $sql="SELECT * FROM school_classes_structure WHERE acedemic_session='$acedemic_session' ORDER BY course_id,class,section";
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    
    public function check_class_subject_data($class,$subject,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$class);
        $this->db->where('subject',$subject);
        // $this->db->where('tid',$tid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_class_subjects($class){
        $sql="SELECT * FROM subject_master ";
        if($class !=""){
            $sql.=" WHERE class='$class'";
        }
        $sql.=" ORDER BY id DESC";
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    
    public function get_teacher_day_schedule($tid,$sch_id,$week_day,$period){
        $table="time_table_record";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('time_table_id',$sch_id);
        // $this->db->where('class',$class);
        // $this->db->where('section',$section);
        $this->db->where('period_id',$period);
        $this->db->where('week_day',$week_day);
        $this->db->where('tid',$tid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_teacher_day_schedule_comb($tid,$sch_id,$week_day,$period){
        $sql="SELECT schedule.*,school_staff.salutation,name FROM time_table_record as schedule LEFT JOIN school_staff ON schedule.tid=school_staff.id WHERE schedule.time_table_id='$sch_id' AND schedule.tid='$tid' AND schedule.week_day='$week_day' AND schedule.period_id='$period'";
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    
    public function update_item_data($id,$data_array_update,$table){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);    
        return $this->db->affected_rows(); 
    }
    
    public function get_active_sch_data($acedemic_session){
        $sql="SELECT * FROM time_table WHERE acedemic_session='$acedemic_session' AND status='active' ORDER BY id DESC LIMIT 1";
        $query = $this->db->query($sql);
        return $query->result_array();
    }
}