<?php
class SchoolModel extends CI_Model {
    
    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function insert_data($table,$data_array){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();	    
    }
    
    public function update_item_data($id,$table,$data_array_update){
        $info =array();	
        $this->db->where("id",$id);
        $info= $this->db->update($table,$data_array_update);
        return $info;
    }
    
    public function update_permission_data($emp_id,$table,$data_array_update){
        $info =array();	
        $this->db->where("emp_id",$emp_id);
        $info= $this->db->update($table,$data_array_update);
        return $info;
    }
    
    public function student_course_data($sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function add_new_data($table,$data_array){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();	    
    }

    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;  
    }
    
    public function fetch_all_enquiry($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('stat','0');
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;  
    } 

    public function fetch_all_paid_enquiry($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('stat','0');
        $this->db->where('enquiry_fee_2020','1');
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;  
    }

    public function fetch_all_pending_enquiry($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('stat','0');
        $this->db->where('enquiry_fee_2020','1');
        $this->db->where('enquiry_approvel','');
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;  
    }

    public function fetch_branch_enquiry($table,$branch){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('stat','0');
        // $this->db->where('enquiry_fee_2020','1');
        // $this->db->where('enquiry_approvel','');
        $this->db->where('branch',$branch);
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;  
    }
    
    public function fetch_all_admissions($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('stat','0');
        $this->db->where('admission_fee_2020','1');
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;  
    }

    public function fetch_enquiry($id){
        $info=array();
        $table ='student_enquiry_2020';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;    
    }
    
    public function add_admission_fee($data_array,$branch){
        $this->db->insert($branch,$data_array);
        return $this->db->insert_id();	    
    }
    
    public function check_admission_fee($class,$branch){
        $this->db->select('*');
        $this->db->from($branch);
        $this->db->where('class',$class);
        return $this->db->get()->num_rows();
    }

    public function fetch_fee($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;    
    }
    
    public function check_enquiry_payment_status($id,$table){
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('enquiry_payment_status',$id);
        return $this->db->get()->num_rows();   
    }
    
    public function grant_admission($id,$val,$table){
        // $this->db->set('is_Success',$is_Success);
        $this->db->set('enquiry_approvel',$val);
        $this->db->where('id',$id);
        $this->db->update($table);     
        return $this->db->get()->num_rows();   
    }
    
    public function reject_admission($id,$val,$table){
        // $this->db->set('is_Success',$is_Success);
        $this->db->set('enquiry_approvel',$val);
        $this->db->where('id',$id);
        $this->db->update($table);     
        return $this->db->get()->num_rows();   
    }
    
    public function fetch_all_payments($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->where('stat','0');
        // $this->db->where('enquiry_payment_status','1');
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;  
    }

    // <td width="25%"><img src="'.base_url().'images/'.$row->student_profile.'" /></td>
    function fetch_single_details($enq){
        $this->db->where('id', $enq);
        $data = $this->db->get('student_enquiry_2020');
        $output = '<table width="100%" cellspacing="5" cellpadding="5">';
        foreach($data->result() as $row){
            $output .= '
                <tr>
                    <td width="25%" height="100px"><img src="'.$row->student_profile.'" width="200px" height="200px" /></td>
                    <td width="75%">
                        <p><b>First Name : </b>'.$row->first_name.'</p>
                        <p><b>Last Name : </b>'.$row->last_name.'</p>
                        <p><b>Class : </b>'.$row->class.'</p>
                        <p><b>Branch : </b>'.$row->branch.'</p>
                        <p><b>Mobile Number : </b> '.$row->mobile_number.' </p>
                    </td>
                </tr>
            ';
        }
        //<td colspan="2" align="center"><a href="'.base_url().'admin" class="btn btn-primary">Back</a></td>  
        $output .= '
            <tr>
      
            </tr>';
            $output .= '</table>';
            return $output;
    }

    public function add_staff($table,$data_array){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();    
    }
    public function check_staff($mobile_number,$table){
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('mobile_number',$mobile_number);    
        $id = $this->db->get()->num_rows();
        return $id;
    }
    
    public function all_teachers(){
        $info=array();
        $this->db->select('*');
        $this->db->from('school_staff');
        $this->db->where('status','0');
        $this->db->order_by('user_status',"DESC");
        $info=$this->db->get()->result_array();
        return $info;     
    }

    public function teacher_profile($tid){
        $info=array();
        $this->db->select('*');
        $this->db->from('school_staff');
        $this->db->where('id',$tid);
        $info=$this->db->get()->result_array();
        return $info;         
    }

    public function update_school_staff($id,$table,$data_array_update){
        $info =array();	
        $this->db->where("id",$id);
        // $data_array = array("result_duty"=>$class_id);
        $info= $this->db->update($table,$data_array_update);
        return $info;
    }

    public function get_teaching_staff($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status','0');
        // $this->db->where('id',$tid);
        $info=$this->db->get()->result_array();
    return $info;    
    }


    public function get_non_teaching_staff($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status','0');
        // $this->db->where('id',$tid);
        $info=$this->db->get()->result_array();
        return $info;    
    }


    public function check_class_section($acedemic_session,$course_id,$class,$section,$table){
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->where('course_id',$course_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('acedemic_session',$acedemic_session);
        $id = $this->db->get()->num_rows();
        return $id;    
    }

    public function check_teacher_duplicacy($acedemic_session,$course_id,$class,$section,$teacher){
        $table ='school_classes_structure';
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->where('course_id',$course_id);
        $this->db->where('class',$class);
        $this->db->where('section',$section);
        $this->db->where('class_teacher',$teacher);
        $this->db->where('acedemic_session',$acedemic_session);
        $id = $this->db->get()->num_rows();
        return $id;        
    }

    public function add_class_teacher($table,$data_array){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();  
    }


    public function update_class_teacher($acedemic_session,$course_id,$class,$section,$teacher,$table){
        $info =array();	
        $this->db->where('course_id',$course_id);
        $this->db->where("class",$class);
        $this->db->where("section",$section);
        $this->db->where("acedemic_session",$acedemic_session);
        $data_array_update=array("class_teacher"=>$teacher);
        $info= $this->db->update($table,$data_array_update);
        return $info;    
    }

    public function update_class_teacher_profile($course_id,$class,$section,$teacher){
        $info =array();	
        $this->db->where("id",$teacher);
        $data_array_update=array("class_teacher_course_id"=>$course_id,"class_teacher"=>$class,"class_teacher_section"=>$section);
        $info= $this->db->update('school_staff',$data_array_update);
        return $info;       
    }


    public function class_teacher_list(){
        $info=array();
        $table='school_classes_structure';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('class');
        // $this->db->where('status','0');
        $info=$this->db->get()->result_array();
        return $info;    
    }
    
    public function class_teacher_list_with_ac_session($acedemic_Session){
        $info=array();
        $table='school_classes_structure';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('class');
        $this->db->where('acedemic_session',$acedemic_Session);
        $info=$this->db->get()->result_array();
        return $info;    
    }

    public function get_teacher_name($tid){
        $info=array();
        $table='school_staff';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$tid);
        $info=$this->db->get()->result_array();
        return $info;        
    }

    public function update_teacher_login_status($status,$id,$table){
        $info =array();	
        $this->db->where("id",$id);
        $data_array_update=array("user_status"=>$status);
        $info= $this->db->update($table,$data_array_update);
        return $info;    
    }


    public function list_admins(){
        $info=array();
        $table='school_staff';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status','0');
        $this->db->where('admin','1');
        $info=$this->db->get()->result_array();
        return $info;    
    }

    public function list_management(){
        $info=array();
        $table='school_staff';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status','0');
        $this->db->where('school_management','1');
        $info=$this->db->get()->result_array();
        return $info;    
    }
    public function list_fee_admins(){
        $info=array();
        $table='school_staff';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status','0');
        $this->db->where('fee_permission','1');
        $info=$this->db->get()->result_array();
        return $info;    
    }
    public function list_document_admins(){
        $info=array();
        $table='school_staff';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status','0');
        $this->db->where('documents','1');
        $info=$this->db->get()->result_array();
        return $info;    
    }

    public function remove_admin($tid,$table){
        $info =array();	
        $this->db->where("id",$tid);
        $data_array_update=array("admin"=>0);
        $info= $this->db->update($table,$data_array_update);
        return $info;    
    }


    public function remove_management($tid,$table){
        $info =array();	
        $this->db->where("id",$tid);
        $data_array_update=array("school_management"=>0);
        $info= $this->db->update($table,$data_array_update);
        return $info;        
    }
    public function official_permission($permission_type,$staff,$table){
        $info =array();	
        $this->db->where("id",$staff);
        $data_array_update=array($permission_type=>1);
        $info= $this->db->update($table,$data_array_update);
        return $info;        
    }

    public function remove_fee_admin($tid,$table){ 	
        $info =array();	
        $this->db->where("id",$tid);
        $data_array_update=array("fee_permission"=>0);
        $info= $this->db->update($table,$data_array_update);
        return $info;       
    }


    public function remove_document_admin($tid,$table){ 	
        $info =array();	
        $this->db->where("id",$tid);
        $data_array_update=array("documents"=>0);
        $info= $this->db->update($table,$data_array_update);
        return $info;       
    }


    public function update_student_status($status,$id,$reason,$table){
        $info =array();	
        $this->db->where("id",$id);
        $data_array_update=array("status"=>$status,"status_description"=>$reason);
        $info= $this->db->update($table,$data_array_update);
        return $info;    
    }

    public function update_circular($id,$data_array,$table){
        $info =array();	
        $this->db->where("id",$id);
        // $data_array = array("result_duty"=>$class_id);
        $info= $this->db->update($table,$data_array);
        return $info;    
    }    

    public function publish_circular($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();      
    }
 
 
    public function check_circular_data($id,$table){
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        return $this->db->get()->num_rows();    
    }    
    public function all_circular($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;        
    }

    public function latest_single_circular($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id',"DESC");
        $this->db->limit(1);
        $info=$this->db->get()->result_array();
        return $info;  
    }
    
    public function get_single_cicular($id){
        $info=array();
        $table='circular';
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;     
    }   

    public function change_section($class){
        $section='B';
        $sec='A';
        $table='student';
    
        $info =array();	
        $this->db->where("class",$class);
        $this->db->where("section",$section);
        $data_array_update=array("section"=>$sec,"section_old"=>$section);
        $info= $this->db->update($table,$data_array_update);
        return $info;     
        

        // $this->db->set('section',$section);
        // $this->db->set('section_old',$sec);
        // $this->db->where('class',$class);
        // $this->db->where('section',$section);
        // $this->db->update($table);     
        // return $this->db->get()->num_rows();  
    }

    public function update_login_credentials($status,$id,$usertype){
        $table='login_credentials';
        $info =array();	
        $this->db->where("user_id",$id);
        $this->db->where("usertype",$usertype);
        $data_array_update=array("status"=>$status);
        $data_array_update=array("usertype"=>$usertype);
        $info= $this->db->update($table,$data_array_update);
        return $info;        
    }
    
    public function update_staff_login_data($id,$usertype,$data_array_update,$table){
        $info =array();	
        $this->db->where("id",$id);
        $this->db->where("usertype",$usertype);
        $info= $this->db->update($table,$data_array_update);
        return $info;
    }
    
    public function get_class_data($class){
        $table='student';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$class);
        // $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function add_class_data($data_array){
        $table='all_students';    
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }


    public function get_student_courses_data($sid){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->order_by('id',"DESC");
        $info=$this->db->get()->result_array();
        return $info;       
    }
    
    public function get_student_data($sid,$student_data_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($student_data_table);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_teacher_course_profile($tid,$acedemic_session){
        $info=array();
        $table='school_classes_structure';
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->order_by('class');
        $this->db->where('class_teacher',$tid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info; 
    }
    public function update_staff_credentials($userid,$usertype,$data_array_update,$table){
        $info =array();	
        $this->db->where("user_id",$userid);
        $this->db->where("usertype",$usertype);
        $info= $this->db->update($table,$data_array_update);
        return $info;
    }
    
    public function get_staff_permissons($staff_id,$staff_permission_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($staff_permission_table);
        $this->db->where("emp_id",$staff_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
}