<?php
class ExamModel extends CI_MODEL{

    public function get_active_subject_data($class){
        $table='exam_subjects';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$class);
        $this->db->order_by('subject_order',"ASC");
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_staff(){
        $table='school_staff';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('user_status',1);
        $this->db->order_by('class_teacher',"ASC");
        $info=$this->db->get()->result_array();
        return $info;
    }


    public function teacher_info($tid){
        $table='school_staff';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$tid);
        // $this->db->order_by('class_teacher',"ASC");
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_exam_result(){
        $table='exam_result';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
// $this->db->where('sid',$sid);
$this->db->order_by('id',"DESC");
$info=$this->db->get()->result_array();
return $info;  
}

public function get_active_courses(){
$table='courses';
$info=array();
$this->db->select('*');
$this->db->from($table);
// $this->db->where('class',$class);
// $this->db->where('section',$section);
$info=$this->db->get()->result_array();
return $info;
}

public function add_exam_subject($data_array,$table){
$this->db->insert($table,$data_array);
return $this->db->insert_id();
}


public function get_subject_data($sub_id){
$table='exam_subjects';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('id',$sub_id);
$info=$this->db->get()->result_array();
return $info;
}

public function my_class_students($class,$section){
$table='student';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('class',$class);
$this->db->where('section',$section);
$this->db->where('status',1);
$this->db->order_by('roll_no','ASC');
$info=$this->db->get()->result_array();
return $info;    
}

public function my_class_student_list($class,$section){
$table='student';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('class',$class);
$this->db->where('section',$section);
$this->db->where('status',1);
// $this->db->order_by('roll_no','ASC');
$info=$this->db->get()->result_array();
return $info;    
}

public function get_student_data($sid){
$table='student';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('id',$sid);
$info=$this->db->get()->result_array();
return $info;    
}

public function add_exam_head($data_array){
$table='exam_heads';
$this->db->insert($table,$data_array);
return $this->db->insert_id();
}

public function get_exam_heads($class){
$table='exam_heads';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('class',$class);
$this->db->order_by('head_order',"ASC");
$info=$this->db->get()->result_array();
return $info;    
}

public function check_exam_log($sid,$sub_id,$exam_head){
$table='exam_log';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('student_id',$sid);
$this->db->where('subject_id',$sub_id);
$this->db->where('exam_head',$exam_head);
$info=$this->db->get()->result_array();
return $info;    
}

public function add_exam_log($data_array){
$table='exam_log';
$this->db->insert($table,$data_array);
return $this->db->insert_id();
}

public function update_exam_log($data_array_update,$sid,$sub_id,$exam_head){
$table='exam_log';
$info =array();	
$this->db->where("subject_id",$sub_id);
$this->db->where("student_id",$sid);
$this->db->where("exam_head",$exam_head);
$info= $this->db->update($table,$data_array_update);
return $info;
}

public function student_exam_log($sid,$exam_head_id,$subject_id){
$table='exam_log';
$info =array();	
$this->db->select('*');
$this->db->from($table);
$this->db->where('subject_id',$subject_id);
$this->db->where('student_id',$sid);
$this->db->where('exam_head',$exam_head_id);
$info=$this->db->get()->result_array();
return $info;    
}

public function update_roll_no($sid,$roll_no){
$table='student';
$this->db->where("id",$sid);
$this->db->update($table,array("roll_no"=>$roll_no));
return $this->db->affected_rows();
}


public function update_house_info($sid,$house){
$table='student';
$this->db->where("id",$sid);
$this->db->update($table,array("house"=>$house));
return $this->db->affected_rows();
}

public function exam_head_data($exam_head_id){
$table='exam_heads';
$info =array();	
$this->db->select('*');
$this->db->from($table);
$this->db->where('id',$exam_head);
// $this->db->where('student_id',$sid);
// $this->db->where('exam_head',$exam_head_id);
$info=$this->db->get()->result_array();
return $info;    
}

public function get_exam_log_data(){
$table='exam_log';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->order_by('id',"DESC");
$info=$this->db->get()->result_array();
return $info;
}


public function get_single_log($ehid,$sub_id,$sid){
 $table='exam_log';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('exam_head',$ehid);
$this->db->where('subject_id',$sub_id);
$this->db->where('student_id',$sid);
$info=$this->db->get()->result_array();
return $info;
}


public function check_remark($sid,$exam_type,$y1,$y2){
$table='remark_quotes';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('sid',$sid);
$this->db->where('quote_for',$exam_type);
$this->db->where('y1',$y1);
$this->db->where('y2',$y2);
$info=$this->db->get()->result_array();
return $info;
}

public function update_remark($sid,$exam_type,$y1,$y2,$data_array_update){
$table='remark_quotes';

$this->db->where("sid",$sid);
$this->db->where("quote_for",$exam_type);
$this->db->where('y1',$y1);
$this->db->where('y2',$y2);
$this->db->update($table,$data_array_update);
return $this->db->affected_rows();
}


public function add_remarks($data_array){
$table='remark_quotes';
$this->db->insert($table,$data_array);
return $this->db->insert_id();
}

public function get_student_remark($sid){
$table='remark_quotes';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('sid',$sid);
$info=$this->db->get()->result_array();
return $info;
}

public function get_course_data($course){
$table='courses';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('course',$course);
$info=$this->db->get()->result_array();
return $info;   
}

public function get_exam_result_data($sid){
$table='exam_result';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('sid',$sid);
$info=$this->db->get()->result_array();
return $info;  
}


public function get_annual_result_data($sid,$result_type1){
$table='exam_result';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('sid',$sid);
$this->db->where('result_type',$result_type1);
$info=$this->db->get()->result_array();
return $info;  
}

public function add_result_data($data_array_result){
$table='exam_result';
$this->db->insert($table,$data_array_result);
return $this->db->insert_id();
}

public function update_result_data($sid,$data_update_result){
$table='exam_result';
// $info =array();	
$this->db->where("sid",$sid);
$this->db->update($table,$data_update_result);
// return $info;
return $this->db->affected_rows();
}


public function update_subject_info($subject_id,$subject_type){
$table='exam_subjects';
$data_update_array=array("subject_type"=>$subject_type);
$this->db->where("id",$subject_id);
$this->db->update($table,$data_update_array);
// return $info;
return $this->db->affected_rows();
}

public function error_log($sid,$sub_id){
 $table='exam_log';
$info=array();
$this->db->select('*');
$this->db->from($table);
// $this->db->where('exam_head',$ehid);
$this->db->where('subject_id',$sub_id);
$this->db->where('student_id',$sid);
$info=$this->db->get()->result_array();
return $info;   
}
// public function delete_single_data($id){
// $this->db->where('id',$id);
// $this->db->delete('exam_log');
// }


// public function get_rsult_for_class($eclass){
// $table='exam_result';
// $info=array();
// $this->db->select('*');
// $this->db->from($table);
// $this->db->where('sid',$sid);
// $info=$this->db->get()->result_array();
// return $info;     
// }

public function get_student_result_rank($acedemic_session,$eclass,$section){
$table='exam_result';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('class',$eclass);
$this->db->where('result_type','half_yearly');
$this->db->where('section',$section);
$this->db->where('acedemic_session',$acedemic_session);
$this->db->order_by('percentage',"DESC");
$info=$this->db->get()->result_array();
return $info;
}

public function get_student_annual_result_rank($eclass,$section){
$table='exam_result';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('class',$eclass);
$this->db->where('section',$section);
$this->db->where('result_type','yearly');
$this->db->order_by('percentage',"DESC");
$info=$this->db->get()->result_array();
return $info;
}

public function school_classes_structure($eclass,$section){
$table='school_classes_structure';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('class',$eclass);
$this->db->where('section',$section);
$info=$this->db->get()->result_array();
return $info;
}

public function get_all_annual_students(){
$table='exam_result';
$info=array();
$this->db->select('*');
$this->db->from($table);
// $this->db->where('class',$eclass);
$this->db->where('result_type','yearly');
// $this->db->where('section',$section);
// $this->db->order_by('percentage',"DESC");
$info=$this->db->get()->result_array();
return $info;   
}

public function update_result($sid,$exam_mode,$data_array){
$table='exam_result';
$this->db->where('sid',$sid);
$this->db->where('result_type',$exam_mode);
$this->db->update($table,$data_array);
return $this->db->affected_rows();
}
public function get_student_course_info($sid,$acedemic_session){
$table='student_courses_data';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('sid',$sid);
$this->db->where('acedemic_session',$acedemic_session);
$info=$this->db->get()->result_array();
return $info;   
}
}