<?php
class EnquiryModel extends CI_Model {
    
    public function get_current_enquiry($acedemic_session,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by("id","DESC");
        $info=$this->db->get()->result_array();
        return $info;      
    }
    
    public function get_table_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;    
    }
    
    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }
    
    public function get_item_info($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;   
    }

    public function update_item_data($data_array_update,$id,$table){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function check_short_enquiry($first_name,$last_name,$father_name,$mobile_number,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('mobile_number',$mobile_number);   
        $this->db->where('first_name',$first_name);
        $this->db->where('last_name',$last_name);
        $this->db->where('father_name',$father_name);
        return $this->db->get()->num_rows();   
    }
 
    public function add_enquiry($data_array,$table){
        $this->db->insert('enquiry',$data_array);
        return $this->db->insert_id();
    }

    public function get_annual_fee_data($acedemic_session_current,$fee_heads_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($fee_heads_table);
        $this->db->where('fee_type','yearly');   
        /*$this->db->where('acedemic_session',$acedemic_session_current);*/
        $info=$this->db->get()->result_array();
        return $info;   
    }
    public function get_fee_structure_for_head_and_ac_session($fee_head_id,$acedemic_session_current,$course_id){
        $table='fee_structure';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('course_id',$course_id);   
        $this->db->where('fee_head',$fee_head_id);   
        $this->db->where('acedemic_session',$acedemic_session_current);
        $info=$this->db->get()->result_array();
        return $info;   
    }
    public function check_fee_exist($fee_info,$enquiry_id,$acedemic_session){
        $table='student_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('enquiry_id',$enquiry_id);   
        $this->db->where('fee_info',$fee_info);   
        // $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;   
    }
    public function get_all_enquiry($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by("id","DESC");
        $info=$this->db->get()->result_array();
        return $info;      
    }

    public function enquiry_fee_invoices($enquiry_id){
        $table='student_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('enquiry_id',$enquiry_id); 
        $this->db->order_by("fee_no","DESC");
        $info=$this->db->get()->result_array();
        return $info;
    }

}