<?php
class DeveloperModel extends CI_Model {
    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }

    
    
    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function check_student_session($sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;        
    }

    public function update_all($table){
        $this->db->set('acedemic_session',1);
        $this->db->update($table);     
        return $this->db->affected_rows();
    }

    public function close_attendance($table){
        $this->db->set('closed',1);
        $this->db->update($table);     
        return $this->db->affected_rows(); 
    }

    public function update_data($students_data_array,$sid,$student_table){
        $info =array();	
        $this->db->where("id",$sid);
        $info= $this->db->update($student_table,$students_data_array);
        return $info;   
    }
    public function check_enquiry_student_exist($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('enquiry_id',$id);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    public function course_students_pdf($course,$acedemic_session){
        $this->db->where('acedemic_session', $acedemic_session);
        $this->db->where('class',$course);
        $data = $this->db->get('student_courses_data');
        $output ="<html><head>";
        $output .='<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" >
            <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap-theme.min.css" >
            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js" ></script>
            <link rel="preconnect" href="https://fonts.gstatic.com">
            <link href="https://fonts.googleapis.com/css2?family=Bree+Serif&display=swap" rel="stylesheet"> 
            <style>';

        $output .="body{font-family: 'Bree Serif', serif;}";
        $output .='table {
            width: 100%;
            margin:0px;padding:0px;
            }
            th, td {
            padding: 5px;
            }
            table tr{padding:0px;}
            th{font-weight:600;font-size:10px;}
            td{font-weight:600;font-size:10px;}


            </style>
            </head>
            <body>';

        $output .='<div class="conatiner-fluid">
                    <div class="row>
                    <div class="col-sm-12">';

        $output .='<table>';
        $output .='<tbody>';
                
        foreach($data->result() as $student_data){
            $sid =$student_data->sid;
            $this->db->where('id', $sid);
            $data1 = $this->db->get('student');
            foreach($data1->result() as $row){
                $output .='<tr>';
                $output .='<td>'.$row->student_name.'</td>';
                $output .='<td></td>';
                $output .='<td></td>';
                $output .='<td></td>';
                $output .='</tr>';
            }
        }    
            $output .='</table>';
            $output .='</div>';
            $output .='</div>';
            $output .='</div>';
            return $output;
    }
        
    public function delete_from_student_courses_data(){
            // $this -> db -> where('class', 13);
            // $this -> db -> delete('student_courses_data');
            // return $this->db->affected_rows(); 
    }
    
    
    public function delete_item_data($id,$table){
        $this -> db -> where('id', $id);
        $this -> db -> delete($table);
        return $this->db->affected_rows(); 
    }
    
    
    public function get_course_students($course,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$course);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }



    public function get_course_students_data($course_id,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('course_id',$course_id);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    public function get_undefined_students($course,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('class',$course);
        // $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_student_imp_refrence($ref_id){
        $table='student';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('impor_ref_id',$ref_id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_active_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;       
    }
    
    public function update_course_id($course,$course_id,$student_table){
        $this->db->where('class',$course);
        $this->db->set('course_id',$course_id);
        $this->db->update($student_table);
        return $this->db->affected_rows();
    }
    
    function get_course_students_old($course_id){
        $table='student';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->where('course_id',$course_id);
        $info=$this->db->get()->result_array();
        return $info;           
    }
    
    public function get_deleted_students_for_course($course){
        $table='students_deleted';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->where('status',1);
        $this->db->where('class',$course);
        $info=$this->db->get()->result_array();
        return $info;           
    }
    
    public function update_course_id_for_class($course,$course_id,$student_table){
        $this->db->where('course_id',0);
        $this->db->where('class',$course);
        $this->db->set('course_id',$course_id);
        $this->db->update($student_table);
        return $this->db->affected_rows();
    }
    
    public function update_student_status(){
        $student_table='student_courses_data';
        // $this->db->where('status',0);
        // $students_data_array=array("status"=>1,"status_description"=>"Active");
                $students_data_array=array("section"=>"A");
        $this->db->update($student_table,$students_data_array);
        return $this->db->affected_rows();
    }
    
    public function get_course_old_students($course,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('status',1);
        $this->db->where('class',$course);
        $this->db->where('impor_ref_id',0);
        $info=$this->db->get()->result_array();
        return $info;           
    }
    
    public function make_student_passout($sid){
        $student_table='student';
        $students_data_array=array("status"=>2,"status_description"=>"Pass Out");
        $this->db->where('id',$sid);
        $this->db->update($student_table,$students_data_array);
        return $this->db->affected_rows();       
    }
    public function get_student_promoted($sid,$data_array_update){
        $student_table='student';
        $this->db->where('id',$sid);
        $this->db->update($student_table,$data_array_update);
        return $this->db->affected_rows();       
    }
    
    public function get_student_fee_data($sid,$acedemic_session){
        $table='student_fee';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;       
    }
    
    public function update_opening_fee_for_ac_sess($fee_for_ac_sess,$table){
        $this->db->where('fee_for_ac_sess',0);
        $data_array_update=array("fee_for_ac_sess"=>$fee_for_ac_sess);
        $this->db->update($table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function update_student_invoice_info($fee_no,$data_array_update,$fee_table){
        $this->db->where('fee_no',$fee_no);
        $this->db->update($fee_table,$data_array_update);
        return $this->db->affected_rows();
    }
    
    public function get_session_students_result($acedemic_session,$result_table){
        $info=array();
        $this->db->select('*');{
            
        }
        $this->db->from($result_table);
        // $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;       
    }
    
    public function update_item_data($id,$data_array_update,$table){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);    
        return $this->db->affected_rows(); 
    }
    
    public function get_student_course_data($acedemic_session){
        $table="student_courses_data";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;   
    }
    public function get_student_course_data_a($sid,$acedemic_session){
        $table="student_courses_data";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('sid',$sid);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_class_students($class,$acedemic_session,$scd_table){
        $info=array();
        $this->db->select('*');
        $this->db->from($scd_table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->where('class',$class);
        // $this->db->where('status',1);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_student_subjects_exists($sid){
        $sql="SELECT DISTINCT sid FROM student_subjects_4 WHERE sid='$sid'";
        $query=$this->db->query($sql);        
        return $query->result_array();
    }
    
}