<?php
class CertificateModel extends CI_Model {
    
    public function insert_data($data_array,$table){
        $this->db->insert($table,$data_array);
        return $this->db->insert_id();
    }

    public function update_item_data($id,$table,$data_array_update){
        $this->db->where("id",$id);
        $this->db->update($table,$data_array_update);    
        return $this->db->affected_rows(); 
    }
    
    public function get_data($table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->order_by('id','DESC');
        $info=$this->db->get()->result_array();
        return $info;
    }

    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function getstudents_in_alpha_order(){
        $table='student';
        $info=array();
        $this->db->select('*');
        $this->db->order_by('student_name','ASC');
        $this->db->from($table);
        $info=$this->db->get()->result_array();
        return $info;  
    }
    
    public function student_course_data($sid,$acedemic_session){
        $table='student_courses_data';
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('acedemic_session',$acedemic_session);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function check_doc_date_and_type($sid,$doc_type,$issuing_date,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('issuing_date',$issuing_date);
        $this->db->where('doc_type',$doc_type);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function get_doc($sid,$doc_type,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('sid',$sid);
        $this->db->where('doc_type',$doc_type);
        $info=$this->db->get()->result_array();
        return $info;
    }
    
}