<?php
class AttendenceModel extends CI_Model {
    
    public function get_item_data($id,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('id',$id);
        $info=$this->db->get()->result_array();
        return $info;        
    }
    
    public function get_all_classes_structure($acedemic_session){
        $table="school_classes_structure";
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->order_by('course_id','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
public function class_attendence($class,$section,$date,$table){
    //   $info=array();
      $this->db->select('*');
      $this->db->from('attendence');
      $this->db->order_by('sid');
      $this->db->where('class',$class);
      $this->db->where('section',$section);
      $this->db->where('date',$date);      
      $info=count($this->db->get()->result_array());
      return $info;    
}
public function check_closed($class,$section,$date,$table){
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('class',$class);
$this->db->where('section',$section);
$this->db->where('date',$date);
$this->db->where('closed','1');
$info=count($this->db->get()->result_array());
return $info;    
}

// public function class_attendence($class,$section,$date,$table){
// $info=array();
// $this->db->select('*');
//       $this->db->from('attendence');
//       $this->db->order_by('sid');
//       $this->db->where('class',$class);
//       $this->db->where('section',$section);
//       $this->db->where('date',$date);      
//       $info=count($this->db->get()->result_array());
//       return $info;    
// }


    public function student_by_class($acedemic_session,$class,$section){
        $info=array();
        $this->db->select('*');
        $this->db->from('student_courses_data');
        //   $this->db->order_by('class');
        $this->db->where('class',$class);
        $this->db->where('acedemic_session',$acedemic_session);
          $this->db->where('status',1);
        $this->db->where('section',$section);
          $this->db->order_by('roll_no','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }


public function attendence($table,$data_array){
$this->db->insert($table,$data_array);
return $this->db->insert_id();
}    

    public function student_attendence_by_id($sid,$class,$section,$date,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->order_by('sid');
        //   $this->db->where('class', $class);
        $this->db->where('sid',$sid);
        $this->db->where('date',$date);
        $info=$this->db->get()->result_array();
        return $info;     
    }
    
    public function student_attendence_by_id_1($sid,$date,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from('attendence');
        $this->db->where('sid',$sid);
        $this->db->where('date',$date);
        $info=$this->db->get()->result_array();
        return $info;     
    }
public function class_attendence_data($class,$section,$date,$table,$status){
$info=array();
$this->db->select('*');
      $this->db->from('attendence');
      $this->db->order_by('sid');
      $this->db->where('class',$class);
      $this->db->where('section',$section);
      $this->db->where('status',$status);
      $this->db->where('date',$date);      
      $info=count($this->db->get()->result_array());
      return $info;	
}


    public function check_student_attendence($id,$date,$table){
        $info=array();
        $this->db->select('*');
        $this->db->from($table);
        //   $this->db->order_by('sid');
        $this->db->where('sid', $id);      
        $this->db->where('date', $date);
        $info=$this->db->get()->result_array();
        return $info;     
    }

    public function set_attendence($val,$id,$table,$date){
        $data_array=array("status"=>$val,"last_updated"=>date('Y-m-d H:i:s'));
        $this->db->where("sid",$id);
        $this->db->where('date',$date);
        $this->db->update($table,$data_array);
        return $this->db->affected_rows();
    }

public function close_attendence($class,$section,$date,$table){
$this->db->where("class",$class);
$this->db->where("section",$section);
$this->db->where('date',$date);
$this->db->update($table,array("closed"=>1));
return $this->db->affected_rows();
}


public function class_attendance_data($date,$class,$section){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('date',$date);   
$this->db->where('class',$class);  
$this->db->where('section',$section);  
$info=$this->db->get()->result_array();
return $info;
}

public function school_strength($date){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('date',$date);   
// $this->db->where('class',$class);  
// $this->db->where('section',$section);  
$info=$this->db->get()->result_array();
return $info;    
}

public function check_holiday($date){
$info=array();
$this->db->select('*');
$this->db->from('school_calender');
$this->db->where('holiday_date',$date);   
$info=$this->db->get()->result_array();
return $info;    
}


public function make_open_attendance($date,$class,$section){
$table='attendence';
$this->db->where("class",$class);
$this->db->where("section",$section);
$this->db->where('date',$date);
$this->db->update($table,array("closed"=>0));
return $this->db->affected_rows();    
}


public function get_courses($table){
$info=array();
$this->db->select('*');
$this->db->from($table);
// $this->db->where('holiday_date',$date);   
$info=$this->db->get()->result_array();
return $info;        
}

public function attendance_history_by_class($log_date,$class,$section){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('class',$class);
$this->db->where('section',$section);
$this->db->where('date',$log_date);
$this->db->order_by('sid');
$info=$this->db->get()->result_array();
return $info;    
}

public function get_attendance_row(){
    $info=array();
$this->db->select('*');
$this->db->from('attendence');
$info=$this->db->get()->result_array();
return $info;  
}


public function attendance_dmy_update($id,$data_array){
$table='attendence';
$this->db->where('id',$id);
$this->db->update($table,$data_array);
return $this->db->affected_rows();    
}

public function class_attendance_data_history($day,$month,$year,$class,$section){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('class',$class);
$this->db->where('section',$section);
$this->db->where('day',$day);
$this->db->where('month',$month);
$this->db->where('year',$year);
$this->db->order_by('id');
$info=$this->db->get()->result_array();
return $info;        
}

public function update_year($year){
$table='attendence';    
$this->db->where("year",20);
// $this->db->where('date',$date);
$this->db->update($table,array("year"=>$year));
return $this->db->affected_rows();    
}


public function add_log($date,$eclass,$section,$tid,$cat){
$data_array=array("permission_by"=>$tid,"cat"=>$cat,"class"=>$eclass,"sec"=>$section,"permission_for_date"=>$date);
$table='attendance_permission_log';
$this->db->insert($table,$data_array);
return $this->db->insert_id();    
}

public function student_data($id,$table){
$info=array();
$this->db->select('*');
$this->db->from($table);
// $this->db->order_by('sid');
// $this->db->where('class', $class);
$this->db->where('id', $id);
// $this->db->where('date', $date);
$info=$this->db->get()->result_array();
return $info;        
}

public function teacher_info($tid){
$table='school_staff';
$info=array();
$this->db->select('*');
$this->db->from($table);
$this->db->where('id',$tid);
$info=$this->db->get()->result_array();
return $info;          
}
public function attendance_by_tid($day,$month,$year,$tid){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('teacher_id',$tid);
$this->db->where('day',$day);
$this->db->where('month',$month);
$this->db->where('year',$year);
// $this->db->order_by('id');
$info=$this->db->get()->result_array();
return $info;    
}

    public function marked_pending_attendance($acedemic_session,$tid){
        $info=array();
        $this->db->select('*');
        $this->db->from('attendence');
        $this->db->where('teacher_id',$tid);
        $this->db->where('closed',0);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->limit(1); 
        $this->db->order_by('id','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    public function marked_pending_attendance_by_class($acedemic_session,$calss,$section){
        $info=array();
        $this->db->select('*');
        $this->db->from('attendence');
        $this->db->where('class',$calss);
        $this->db->where('section',$section);
        $this->db->where('closed',0);
        $this->db->where('acedemic_session',$acedemic_session);
        $this->db->limit(1); 
        $this->db->order_by('id','ASC');
        $info=$this->db->get()->result_array();
        return $info;
    }
    
    

public function marked_pending_attendance_data($tid,$date){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('teacher_id',$tid);
$this->db->where('date',$date);
$this->db->where('closed',0);
$this->db->order_by('id');
$info=$this->db->get()->result_array();
return $info;
}
public function close_old_attendance($class,$section,$date,$table,$note,$cat){
$this->db->where("class",$class);
$this->db->where("section",$section);
$this->db->where('date',$date);
$this->db->update($table,array("closed"=>1,"close_note"=>$note,"close_at"=>$cat));
return $this->db->affected_rows();
}

public function class_attendance_data_history_in_limit($day,$month,$year,$class,$section){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('class',$class);
$this->db->where('section',$section);
$this->db->where('day',$day);
$this->db->where('month',$month);
$this->db->where('year',$year);
$this->db->limit(1); 
$this->db->order_by('id');
$info=$this->db->get()->result_array();
return $info;        
}


public function student_attendance_data_history_in_limit($day,$month,$year,$sid){
$info=array();
$this->db->select('*');
$this->db->from('attendence');
$this->db->where('sid',$sid);
// $this->db->where('section',$section);
$this->db->where('day',$day);
$this->db->where('month',$month);
$this->db->where('year',$year);
// $this->db->limit(1); 
// $this->db->order_by('id');
$info=$this->db->get()->result_array();
return $info;        
}

public function close_all_attendance(){
$table='attendence';
$this->db->where('closed',0);
$this->db->update($table,array("closed"=>1));
return $this->db->affected_rows();
}

}
?>